/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea

import endea.engine._
import endea.internal._
import endea.internal.http._
import java.io._

object Endea extends Application {

  Runtime.getRuntime().addShutdownHook(new Thread() {
    override def run() = {
      Endea.stop()
    }
  })

  lazy val path: File = {

    val dir = new File("endea")
    if (!dir.exists())
      dir.mkdirs()

    dir

    //    val file = new File(System.getProperty("user.home") + "/endea")
  }

  lazy val tmpPath: File = {

    val dir = new File(path, "tmp")
    if (!dir.exists())
      dir.mkdirs()

    dir
  }

  override def start() {

    val classLoader = classOf[Module].getClassLoader()

    for (module <- Module.modules) {
      module.activator match {
        case Some(activator) =>
          try {
            classLoader.loadClass(activator).
              newInstance().asInstanceOf[Activator].start()
          } catch {
            case e: ClassNotFoundException =>
              System.err.println("Class not found: " + activator)
          }
        case _ => System.err.println("No activator: " + module)
      }
    }

    HttpServer.start
  }

  override def stop() {

  }

  def main(args: Array[String]) = {
    start()
  }
}