/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea

import endea.internal._
import endea.internal.entity._

object Entity {

  def instance(bytes: Array[Byte]): Entity = Serial.instance(bytes)

  def get[E <: Entity](id: Long)(implicit manifest: Manifest[E]): Option[E] = {
    EntityStore.get(id)
  }

  def cursor[E <: Entity](implicit manifest: Manifest[E]): EntityCursor[E] = {

    val meta = MetaObject.getByClass(manifest.erasure)
    //val filter = metaEntity.id // TODO +  get sub ids

    // TODO
    new EntityCursorImpl(EntityStore.class_attribute)
  }
}

abstract class Entity {

  val id: Long = 0

  final def bytes: Array[Byte] = Serial.bytes(this)

  def persist() {
    EntityStore.put(this)
  }

  override def equals(that: Any) = that match {
    case entity: Entity => id == entity.id
    case _ => false
  }

  override def hashCode() = id.toInt
}





