/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.html

import endea.http._
import scala.collection.mutable._

object Adapter {

  val adapters = new HashMap[Class[_], Adapter[_]]

  add[String](new StringAdapter())

  def add[T](adapter: Adapter[T])(implicit clazz: Manifest[T]) {
    adapters += Class.forName(clazz.toString()) -> adapter
  }

  def get(clazz: Class[_]) = {

    adapters(clazz)
  }

  private class StringAdapter extends Adapter[String] {

    override def read(event: Event[_], string: String) {
      event.write(string)
    }
  }
}

trait Adapter[T] {

  def read(event: Event[_], any: T)
}