/*
 * Copyright 2012 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.html

import endea._
import endea.html._
import endea.http._
import endea.internal._

object DefaultAction extends HtmlAction[Entity] {

  val css = None
  val js = None

  def write(event: Event[Entity]) {

    val entity = event.entity
    val metaEntity = MetaObject.getByObject(entity)

    event.write("<dl id=\"view\">\n")
    for (attribute <- metaEntity.attributes) {
      event.write("<dt class=\"att\">")
      event.write(attribute.field.getName())
      event.write("</dt><dd class=\"att\">")
      val value = attribute.field.get(entity)
      if (value != null) {
        // TODO list (see viewAction)
        val adapter = Adapter.get(attribute.field.getType()).asInstanceOf[Adapter[Any]]
        adapter.read(event, value)

      }
      event.write("</dd>\n")
    }

    event.write("</dl>\n")
  }
}