/*
 * Copyright (c) 2011, 2012, David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.html

import endea._
import endea.http._
import endea.internal.html._
import endea.internal.auth._

object HtmlConfig {

  var title = "Endea"
  var favicon = Resource(HtmlConfig, "favicon.ico")
  var css = Resource(HtmlConfig, "style.css")

  var jquery = Resource(HtmlConfig, "jquery-1.7.1.min.js")
  var jquery_ui = Resource(HtmlConfig, "jquery-ui-1.8.16.js")

  val homeControl = HomeControl
  val authControls = List[Control](LoginControl, MeControl, LogoutControl)
  var controls: List[Control] = HomeControl :: authControls

  def ++(controls: List[Control]) {
    this.controls = homeControl :: controls ++ authControls
  }
}