/*
 * Copyright (c) 2011, David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.html

import endea.Endea
import endea.http.Event
import java.io.File
import resource._

object ImageView {

  def write(event: Event[_], image: Option[Image], height: Int = -1, gray: Boolean = false) {

    image match {
      case None =>
      case Some(image) =>

        event.write("<img src=\"")

        if (height == -1)
          image.resource.write(event)
        else {

          val resource = image.resource
          //TODO tmp
          event.write("/resource/")
          event.write(resource.crc)

          event.write("/")
          event.write(height.toString())
          if (gray)
            event.write("g")

          event.write(resource.name)

          event.write("\" height=\"")
          event.write(height.toString())
          event.write("\" width=\"")
          event.write(height.toString())
        }

        event.write("\" />")
    }
  }
}