/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.data

import endea._
import endea.internal._

object DataDecoder {

  def instance[D <: Data](decoder: ByteDecoder, metaObject: MetaObject): D = {

    val data = metaObject.newInstance().asInstanceOf[D]

    for (attribute <- metaObject.attributes) {
      attribute.field.getType match {
        case Field.IC =>
          attribute.field.set(data, decoder.readVarInt())
        case Field.SC =>
          attribute.field.set(data, decoder.readString())
      }
    }

    data
  }
}
