/*
 * Copyright (c) 2012, David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.entity

import endea.Entity

import endea.internal.Module
import scala.collection.mutable.ListBuffer

object MetaEntity {

  lazy val id = {
    val id = classOf[Entity].getDeclaredField("id")
    id.setAccessible(true)
    id
  }

  lazy val all = {

    val entities = new ListBuffer[Class[_ <: Entity]]

    val classLoader = classOf[Module].getClassLoader()
    for (
      module <- Module.modules;
      entity <- module.entities
    ) {
      try {
        // TODO test class is assignable Class[Entity]
        entities += classLoader.loadClass(entity).asInstanceOf[Class[_ <: Entity]]
      } catch {
        case e: ClassNotFoundException =>
          System.err.println(entity + " not found - " + module)
      }
    }

    entities
  }
}