/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.http

import endea._
import endea.http._
import endea.internal.http._
import java.net.URL
import java.util.Date
import java.util.zip.CRC32
import javax.servlet.http._
import resource.{ Resource => _, _ }
import scala.collection.mutable.HashMap

object ResourceAction extends HttpAction[Resource] {

  private val ONE_YEAR = 31557600000L
  private val BUFFER_SIZE = 1024

  def doGet(event: Event[Resource]) {

    val resource = event.entity

    val response = event.httpResponse
    response.setDateHeader("Expires", new Date().getTime() + ONE_YEAR);
    response.setContentType(resource._type)

    val buffer = new Array[Byte](BUFFER_SIZE)
    for (
      input <- managed(resource.url.openStream());
      output <- managed(response.getOutputStream())
    ) {

      Stream.continually(input.read(buffer)).
        takeWhile(_ != -1).
        foreach(output.write(buffer, 0, _))
    }
  }
}