/*
 * Decompiled with CFR 0.152.
 */
package endea.http;

import endea.Endea$;
import endea.http.Resource;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Resource$
implements ScalaObject {
    public static final Resource$ MODULE$;
    private final File imageDir;
    private final HashMap<String, Resource> map;

    static {
        new Resource$();
    }

    private File imageDir() {
        return this.imageDir;
    }

    private HashMap<String, Resource> map() {
        return this.map;
    }

    public Option<Resource> get(String name) {
        URL url;
        Option option = this.map().get((Object)name);
        return option instanceof Some ? (Some<Resource>)option : (name.startsWith("/g/") || Character.isDigit(name.charAt(2)) ? this.createImage(name) : ((url = this.getClass().getResource(name)) == null ? None$.MODULE$ : this.add(name, url)));
    }

    public Option<Resource> apply(Object context, String name) {
        return this.get(context.getClass().getName(), name);
    }

    public <T> Option<Resource> apply(String name, Manifest<T> context) {
        return this.get(context.toString(), name);
    }

    private Option<Resource> get(String className, String name) {
        int index = className.lastIndexOf(46);
        String bname = index == -1 ? "/" : new StringBuilder().append((Object)"/").append((Object)className.substring(0, index).replace('.', '/')).append((Object)"/").toString();
        Option<Resource> resource = this.get(bname = new StringBuilder().append((Object)bname).append((Object)name).toString());
        if (!resource.isDefined()) {
            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"? ").append((Object)bname).toString());
        }
        return resource;
    }

    private Some<Resource> add(String name, URL url) {
        Resource resource = new Resource(name, url);
        this.map().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)name).$minus$greater((Object)resource));
        return new Some((Object)resource);
    }

    private Option<Resource> createImage(String name) {
        Some<Resource> some;
        int index = name.indexOf(47, 1);
        String image = name.substring(index);
        Option<Resource> option = this.get(image);
        if (option instanceof Some) {
            Resource resource;
            Some some2 = (Some)option;
            Resource resource2 = resource = (Resource)some2.x();
            char c = name.charAt(2);
            if (c == 'g') {
                some = this.gray(resource2, name);
            } else {
                String size = name.substring(1, index);
                if (BoxesRunTime.unboxToChar((Object)Predef$.MODULE$.augmentString(size).last()) != 'g') {
                    some = this.resize(resource2, name, size);
                } else {
                    size = (String)Predef$.MODULE$.augmentString(size).dropRight(1);
                    Resource newResource = (Resource)this.get(new StringBuilder().append((Object)"/").append((Object)size).append((Object)image).toString()).get();
                    some = this.gray(newResource, name);
                }
            }
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    private Some<Resource> resize(Resource resource, String name, String size) {
        InputStream inputStream = resource.url().openStream();
        Some<Resource> exceptionResult1 = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            BufferedImage newImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)Scalr.Method.QUALITY, (int)Integer.parseInt(size), (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            File file = new File(this.imageDir(), name);
            file.getParentFile().mkdirs();
            ImageIO.write((RenderedImage)newImage, "png", file);
            exceptionResult1 = this.add(name, file.toURI().toURL());
            return exceptionResult1;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private Some<Resource> gray(Resource resource, String name) {
        InputStream inputStream = resource.url().openStream();
        Some<Resource> exceptionResult2 = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            ColorConvertOp ccop = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            BufferedImage grayed = ccop.filter(bufferedImage, null);
            File file = new File(this.imageDir(), name);
            file.getParentFile().mkdirs();
            ImageIO.write((RenderedImage)grayed, "png", file);
            exceptionResult2 = this.add(name, file.toURI().toURL());
            return exceptionResult2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private Resource$() {
        MODULE$ = this;
        this.imageDir = new File(Endea$.MODULE$.tmpPath(), "image");
        this.map = new HashMap();
    }
}

