/*
 * Decompiled with CFR 0.152.
 */
package endea.io;

import endea.io.ByteOutput$;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Mr!B\u0001\u0003\u0011\u000b9\u0011A\u0003\"zi\u0016|U\u000f\u001e9vi*\u00111\u0001B\u0001\u0003S>T\u0011!B\u0001\u0006K:$W-Y\u0002\u0001!\tA\u0011\"D\u0001\u0003\r\u0015Q!\u0001#\u0002\f\u0005)\u0011\u0015\u0010^3PkR\u0004X\u000f^\n\u0004\u00131!\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u00067%!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAqAH\u0005C\u0002\u0013\u0005q$A\u0004dQ\u0006\u00148+\u001a;\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u000f\rD\u0017M]:fi*\u0011Q\u0005E\u0001\u0004]&|\u0017BA\u0014#\u0005\u001d\u0019\u0005.\u0019:tKRDa!K\u0005!\u0002\u0013\u0001\u0013\u0001C2iCJ\u001cV\r\u001e\u0011\u0007\t)\u0011\u0001aK\n\u0004U1!\u0002\u0002C\u0017+\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u000f\rD\u0017M\u001c8fYB\u0011qFM\u0007\u0002a)\u0011\u0011\u0007J\u0001\tG\"\fgN\\3mg&\u00111\u0007\r\u0002\u0014'\u0016,7.\u00192mK\nKH/Z\"iC:tW\r\u001c\u0005\u00077)\"\tAA\u001b\u0015\u0005Y:\u0004C\u0001\u0005+\u0011\u0015iC\u00071\u0001/\u0011\u001dI$F1A\u0005\ni\naAY;gM\u0016\u0014X#A\u001e\u0011\u0005qjT\"\u0001\u0013\n\u0005y\"#A\u0003\"zi\u0016\u0014UO\u001a4fe\"1\u0001I\u000bQ\u0001\nm\nqAY;gM\u0016\u0014\b\u0005C\u0003CU\u0011\u00051)A\u0002qkR$\"\u0001R$\u0011\u0005U)\u0015B\u0001$\u0017\u0005\u0011)f.\u001b;\t\u000b!\u000b\u0005\u0019A%\u0002\t\tLH/\u001a\t\u0003+)K!a\u0013\f\u0003\t\tKH/\u001a\u0005\u0006\u001b*\"\tAT\u0001\u0007aV$\u0018J\u001c;\u0015\u0005\u0011{\u0005\"\u0002)M\u0001\u0004\t\u0016aA5oiB\u0011QCU\u0005\u0003'Z\u00111!\u00138u\u0011\u0015)&\u0006\"\u0001W\u0003%\u0001X\u000f\u001e,be&sG\u000f\u0006\u0002E/\")\u0001\u000b\u0016a\u0001#\")\u0011L\u000bC\u00015\u00069\u0001/\u001e;M_:<GC\u0001#\\\u0011\u0015a\u0006\f1\u0001^\u0003\u0011awN\\4\u0011\u0005Uq\u0016BA0\u0017\u0005\u0011auN\\4\t\u000b\u0005TC\u0011\u00012\u0002\u0015A,HOV1s\u0019>tw\r\u0006\u0002EG\")A\f\u0019a\u0001;\")QM\u000bC\u0001M\u0006A\u0001/\u001e;GY>\fG\u000f\u0006\u0002EO\")\u0001\u000e\u001aa\u0001S\u0006)a\r\\8biB\u0011QC[\u0005\u0003WZ\u0011QA\u00127pCRDQ!\u001c\u0016\u0005\u00029\f\u0011\u0002];u\t>,(\r\\3\u0015\u0005\u0011{\u0007\"\u00029m\u0001\u0004\t\u0018A\u00023pk\ndW\r\u0005\u0002\u0016e&\u00111O\u0006\u0002\u0007\t>,(\r\\3\t\u000bUTC\u0011\u0001<\u0002\u0015A,HOQ8pY\u0016\fg\u000e\u0006\u0002Eo\")\u0001\u0010\u001ea\u0001s\u00069!m\\8mK\u0006t\u0007CA\u000b{\u0013\tYhCA\u0004C_>dW-\u00198\t\u000buTC\u0011\u0001@\u0002\u0013A,Ho\u0015;sS:<GC\u0001#\u0000\u0011\u001d\t\t\u0001 a\u0001\u0003\u0007\taa\u001d;sS:<\u0007\u0003BA\u0003\u0003\u0017q1!FA\u0004\u0013\r\tIAF\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%a\u0003\u0003\u0005\u0002\u0014)\"\tAAA\u000b\u0003\u0015\u0019Gn\\:f)\u0005!\u0005bBA\rU\u0011%\u0011QC\u0001\u0006oJLG/\u001a\u0005\b\u0003;QC\u0011BA\u0010\u0003\u001d\u0001X\u000f\u001e\"zi\u0016$2\u0001RA\u0011\u0011\u0019\u0001\u00161\u0004a\u0001#\"\"\u00111DA\u0013!\r)\u0012qE\u0005\u0004\u0003S1\"AB5oY&tW\rC\u0004\u0002\u001e)\"I!!\f\u0015\u0007\u0011\u000by\u0003\u0003\u0004]\u0003W\u0001\r!\u0018\u0015\u0005\u0003W\t)\u0003")
public class ByteOutput
implements ScalaObject {
    private final SeekableByteChannel channel;
    private final ByteBuffer buffer;

    public static final Charset charSet() {
        return ByteOutput$.MODULE$.charSet();
    }

    private ByteBuffer buffer() {
        return this.buffer;
    }

    public void put(byte by) {
        if (this.buffer().remaining() == 0) {
            this.write();
        }
        this.buffer().put(by);
    }

    public void putInt(int n) {
        this.endea$io$ByteOutput$$putByte(n >>> 24);
        this.endea$io$ByteOutput$$putByte(n >>> 16);
        this.endea$io$ByteOutput$$putByte(n >>> 8);
        this.endea$io$ByteOutput$$putByte(n);
    }

    public void putVarInt(int n) {
        int intCopy = n;
        while (true) {
            if ((intCopy & ~127) == 0) {
                this.endea$io$ByteOutput$$putByte(intCopy);
                return;
            }
            this.endea$io$ByteOutput$$putByte(intCopy & 0x7F | 0x80);
            intCopy >>>= 7;
        }
    }

    public void putLong(long l) {
        this.putByte(l >>> 56);
        this.putByte(l >>> 48);
        this.putByte(l >>> 40);
        this.putByte(l >>> 32);
        this.putByte(l >>> 24);
        this.putByte(l >>> 16);
        this.putByte(l >>> 8);
        this.putByte(l);
    }

    public void putVarLong(long l) {
        long longCopy = l;
        while (true) {
            if ((longCopy & (0x7FL ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
                this.putByte(longCopy);
                return;
            }
            this.putByte(longCopy & 0x7FL | 0x80L);
            longCopy >>>= 7;
        }
    }

    public void putFloat(float f) {
        this.putInt(Float.floatToIntBits(f));
    }

    public void putDouble(double d) {
        this.putLong(Double.doubleToLongBits(d));
    }

    public void putBoolean(boolean bl) {
        this.endea$io$ByteOutput$$putByte(bl ? 1 : 0);
    }

    public void putString(String string) {
        char[] chars = string.toCharArray();
        this.putVarInt(chars.length);
        IntRef len$1 = new IntRef(0);
        Predef$.MODULE$.charArrayOps(chars).foreach((Function1)new Serializable(this, len$1){
            public static final long serialVersionUID;
            private final IntRef len$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(char c) {
                this.len$1.elem = c >= '\u0001' && c <= '\u007f' ? ++this.len$1.elem : (c > '\u07ff' ? (this.len$1.elem += 3) : (this.len$1.elem += 2));
            }
            {
                this.len$1 = intRef;
            }
        });
        this.putVarInt(len$1.elem);
        Predef$.MODULE$.charArrayOps(chars).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ByteOutput $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(char c) {
                if (c >= '\u0001' && c <= '\u007f') {
                    this.$outer.endea$io$ByteOutput$$putByte(c);
                } else if (c > '\u07ff') {
                    this.$outer.endea$io$ByteOutput$$putByte(0xE0 | c >> 12 & 0xF);
                    this.$outer.endea$io$ByteOutput$$putByte(0x80 | c >> 6 & 0x3F);
                    this.$outer.endea$io$ByteOutput$$putByte(0x80 | c >> 0 & 0x3F);
                } else {
                    this.$outer.endea$io$ByteOutput$$putByte(0xC0 | c >> 6 & 0x1F);
                    this.$outer.endea$io$ByteOutput$$putByte(0x80 | c >> 0 & 0x3F);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void close() {
        try {
            this.write();
            return;
        }
        finally {
            this.channel.close();
        }
    }

    private void write() {
        this.buffer().flip();
        while (this.buffer().hasRemaining()) {
            this.channel.write(this.buffer());
        }
        this.buffer().clear();
    }

    public final void endea$io$ByteOutput$$putByte(int n) {
        this.put((byte)n);
    }

    private void putByte(long l) {
        this.put((byte)l);
    }

    public ByteOutput(SeekableByteChannel channel) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(8192);
        this.buffer().clear();
    }
}

