/*
 * Copyright 2011 Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea

import endea.engine._
import endea.internal._
import endea.internal.entity._
import endea.internal.http._
import endea.io._
import endea.io.io._

import java.io._
import java.nio.file.Path

object Endea extends Application {

  Runtime.getRuntime().addShutdownHook(new Thread() {
    override def run() = {
      Endea.stop()
    }
  })

  private lazy val test = Thread.currentThread().getStackTrace().
    exists(_.getClassName().startsWith("org.junit.runners."))

  lazy val path: Directory = {

    if (test)
      \\("target") \\ "endea"
    else
      \\("endea")
  }

  lazy val tmpPath: Directory = path \\ "tmp"

  lazy val trashDir = path \\ "trash"

  override def start() {

    val classLoader = classOf[Module].getClassLoader()

    for (module <- Module.modules) {
      module.activator match {
        case Some(activator) =>
          try {
            classLoader.loadClass(activator).
              newInstance().asInstanceOf[Activator].start()
          } catch {
            case e: ClassNotFoundException =>
              System.err.println("Class not found: " + activator)
          }
        case _ => System.err.println("No activator: " + module)
      }
    }

    HttpServer.start
  }

  override def stop() {

  }

  def clear() {

    if (test) {
      tmpPath.delete()
      Resource.clear()
      EntityStore.clear()
    }
  }

  def main(args: Array[String]) = {
    start()
  }
}