/*
 * Copyright (c) 2011, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea

import endea.Entity._
import endea.internal._
import endea.internal.entity._
import scala.collection.immutable.TreeMap

object Entity {

  def get[E <: Entity](id: Long)(implicit manifest: Manifest[E]): Option[E] =
    Get.get(id)

  sealed trait Status
  case object Transient extends Status
  case object Persistent extends Status
  case object Deleted extends Status
}

abstract class Entity {

  /* 731178 ids x ms for 100 years */
  val id: Long = Sequence.next()

  val status: Status = Transient

  def persist() = Put.put(this)

  def delete() = EntityStore.delete(this)

  override def equals(that: Any) = that match {
    case entity: Entity => id == entity.id
    case _ => false
  }

  override def hashCode() = id.toInt
}





