/*
 * Copyright (c) 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea

import java.io.InputStream

import endea.entity.Indexed;
import endea.io._
import endea.io.io._
import java.io.InputStream
import java.nio.file.Files
import javax.imageio.ImageIO
import org.imgscalr.Scalr

object Image {

  private val builder = new ImageBuilder()

  def apply(inputStream: InputStream): Option[Image] =
    Resource.apply[Image](inputStream, builder)

  private class ImageBuilder extends Resource.Builder[Image] {

    def make(file: File) = {

      val bufferedImage = ImageIO.read(file.toInputStream())

      if (bufferedImage == null)
        None
      else
        new Some(new Image("", bufferedImage.getWidth(), bufferedImage.getHeight()))
    }
  }
}

class Image(
  var name: String,
  val width: Int,
  val height: Int) extends Resource {

  @PType(classOf[String])
  @Indexed
  var data: List[String] = Nil

  def format = "jpeg"

  //    def resize(height: Int): Image = {
  //  
  //      val result = Scalr.resize(bufferedImage, Scalr.Method.QUALITY,
  //        height, Scalr.OP_ANTIALIAS)
  //  
  //      new Image(result, format)
  //    }
  //
  //  def writeTo(outputStream: OutputStream) {
  //    if (!ImageIO.write(bufferedImage, format, outputStream))
  //      throw new Exception("No appropiate formatter found for: " + format)
  // }

}