/*
 * Copyright (c) 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea

import endea.io._
import endea.io.io._
import java.io.InputStream
import java.nio.file.Files
import javax.imageio.ImageIO
import org.imgscalr.Scalr
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse
import java.util.Date

object Resource {

  val path = "/resource/"

  private val ONE_YEAR = 31557600000L

  private val dir = Endea.path \\ "resource"

  def apply[T <: Resource](inputStream: InputStream, builder: Builder[T]): Option[T] = {

    val tmpFile: File = Endea.tmpPath tmp

    inputStream.copyTo(tmpFile)

    //    val format = tmpFile.contentType match {
    //      case Some(ct) => ct.substring(ct.indexOf('/') + 1)
    //      case None => throw new Exception("Unknow type")
    //    }

    builder.make(tmpFile) match {
      case Some(resource) =>
        val dstFile = dir \ resource.file
        tmpFile.moveTo(dstFile)
        Some(resource)
      case None =>
        tmpFile.delete()
        None
    }
  }

  def doGet(request: HttpServletRequest, response: HttpServletResponse) {

    val fileName = request.getRequestURI().substring(10)

    val file = dir \ fileName
    if (!file.exists)
      response.sendError(HttpServletResponse.SC_NOT_FOUND)
    else {
      response.setDateHeader("Expires", new Date().getTime() + ONE_YEAR)
      //response.setContentType(resource._type)
      file.copyTo(response.getOutputStream())
    }

  }

  private[endea] def clear() {
    dir.delete()
  }

  trait Builder[T <: Resource] {

    def make(file: File): Option[T]
  }
}

abstract class Resource extends Entity {

  def format: String

  lazy val uri = Resource.path + file

  lazy val file = {

    val hex = id.toHexString

    (if (hex.length() < 3) "-" else hex.take(2)) +
      "/" + hex + "." + format
  }

}