/*
 * Copyright 2012 Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.auth

import endea.html._
import endea.http.Controller
import endea.internal.auth.OpenIdAction

object OAuthProvider {

  private val uri = Controller.encode(OpenIdAction)

  val facebook = new OAuthProvider("facebook", Icon[OAuthProvider]("facebook.png"))
  val google = new OAuthProvider("google", Icon[OAuthProvider]("google.png"))
}

class OAuthProvider(
  val id: String,
  val icon: Option[Icon],
  val uri: String) {

  val name = id.charAt(0).toUpper + id.substring(1)

  def this(id: String, icon: Option[Icon]) = this(id, icon, OAuthProvider.uri + "?provider=" + id)

}