/*
 * Copyright 2011 Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.data

import endea._
import endea.internal._
import endea.internal.data._


object Data {

  private val dataDirectory = Endea.path \\ "data"

  def node[D <: Data](path: String*)(implicit manifest: Manifest[D]): DataNode[D] = {

    val metaData = MetaData.getByClass(manifest.erasure)

    val file = dataDirectory \ (metaData.id + "/" + path.mkString("/"))

    new DataNode(file, metaData)
  }

  def tmpNode[D <: Data](implicit manifest: Manifest[D]) = {
    node("tmp", System.currentTimeMillis().toString())(manifest)
  }
}

trait Data {

}