/*
 * Copyright 2011 Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.data

import endea._
import endea.internal._
import endea.internal.data._
import endea.io._

import scala.collection.mutable.ArrayBuffer

class DataNode[D <: Data](
  private val file: File,
  private val metaData: MetaData) {

  private val SEAL = 0xFF

  private var _sealed: Option[Boolean] = None

  def exists() = file.exists()

  def isSealed(): Boolean = {

    false
    //    _sealed match {
    //      case Some(x) => x
    //      case None =>
    //        if (!file.exists())
    //          false
    //        else {
    //          
    //          file.
    //          for (inputStream <- managed(new FileInputStream(file)))
    //            _sealed = Some(inputStream.read() == SEAL)
    //          _sealed.get
    //        }
    //    }
  }

  def fields(): Array[Field] = {

    var fields = new Array[Field](0)

    //    for (inputStream <- managed(new BufferedInputStream(new FileInputStream(file)))) {
    //      val byteDecoder = new ByteDecoder(inputStream)
    //      _sealed = Some(byteDecoder.read() == SEAL)
    //      fields = Field.read(byteDecoder)
    //    }

    fields
  }

  def write(append: Boolean = true): DataWriter[D] = {
    _sealed match {
      case Some(true) => throw new IllegalStateException("Node is sealed")
      case _ => new WriterImpl(append)
    }
  }

  def read(handler: D => Unit) {

    //    if (file.isEmpty())
    //      return

    file.read(input => {
      _sealed = Some(input.get() == SEAL)
      while (input.hasNext)
        handler(DataDecoder.instance(input, metaData))
    })
  }

  def seal() {

//    for (raf <- managed(new RandomAccessFile(file, "rw")))
//      raf.write(SEAL)
//    _sealed = Option(true)
  }

  override def toString() = {
    "(" + metaData.clazz.getSimpleName() + ") " + "... ..."
  }

  private class WriterImpl(append: Boolean) extends DataWriter[D] {

    var empty = true

//    val outputStream = {
//
//      val directory = file.getParentFile()
//      if (!directory.exists()) directory.mkdirs()
//
//      if (append) {
//        // TODO chech same data format
//        if (!file.exists()) file.createNewFile()
//        else empty = false
//      } else {
//        if (file.exists()) file.delete()
//        file.createNewFile()
//      }
//
//      new BufferedOutputStream(new FileOutputStream(file, append))
//    }
//
//    val byteEncoder = new ByteEncoder(outputStream)

    override def <(data: D) {

//      if (empty) {
//        byteEncoder.write(0)
//        Field.write(byteEncoder, metaData)
//        empty = false
//      }
//
//      DataEncoder.write(byteEncoder, data, metaData.attributes)
    }

    override def close() {
//      if (outputStream != null)
//        outputStream.close()
    }
  }
}