/*
 * Copyright (c) 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.entity

import endea._
import endea.internal._
import endea.internal.entity._

import scala.collection.mutable.ArrayBuffer
import scala.collection.immutable.Stream._

import com.sleepycat.je._

object EntityIndex {

  private val nullId = new DatabaseEntry(Array[Byte](0))

  def apply[K <: Entity, E <: Entity](attribute: String)(implicit manifest: Manifest[E]): EntityIndex[K, E] =
    Index.getIndex[K, E](attribute).asInstanceOf[EntityIndex[K, E]]
}

class EntityIndex[K <: Entity, E <: Entity](id: String)(implicit manifest: Manifest[E])
  extends Index[K, E](id) {

  protected def encode(entity: K) = {

    if (entity == null)
      EntityIndex.nullId
    else
      encodeEntity(entity)
  }
}