/*
 * Copyright 2011 Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.html

import endea.http.Event

abstract class Control {

  def name: String

  def icon: Option[Icon]

  def contribute(event: Event[_]): Boolean

  def url(event: Event[_]): String

  def write(event: Event[_]) {

    //    val controlUrl = control.url(event)
    //
    //    if (!matched && url.equals(controlUrl)) {
    //      matched = true
    //      ImageView.write(event, control.icon(event), 48)
    //
    //    } else {

    event.write("<a href=\"")

    event.write(url(event))
    event.write("\" title=\"")
    event.write(name)
    event.write("\">")
    icon match {
      case Some(icon) => icon.write(event)
      case _ => // TODO
    }
    event.write("</a>\n")
  }
}