/*
 * Copyright (c) 2011, 2012, Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.html

import endea._
import endea.http._
import endea.internal.html._
import endea.internal.auth._

object HtmlConfig {

  var title = "Endea"
  var favicon = ClasspathResource(HtmlConfig, "favicon.ico")
  var css = ClasspathResource(HtmlConfig, "style.css")

//  var jquery = Classpath(HtmlConfig, "jquery-1.7.1.min.js")
//  var jquery_ui = Classpath(HtmlConfig, "jquery-ui-1.8.16.js")

  var homeAction: HtmlAction[Home] = DefaultHomeAction

  val homeControl = HomeControl
  val authControls = List[Control](LoginControl, MeControl, LogoutControl)
  var controls: List[Control] = HomeControl :: authControls

  def ++(controls: List[Control]) {
    this.controls = homeControl :: controls ++ authControls
  }
}