/*
 * Copyright (c) 2012, Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.html

import endea.http.Event
import endea.http._
import endea.io.io._

import java.net.URL
import java.io.OutputStream
import java.io.ByteArrayOutputStream
import java.io.ByteArrayInputStream
import scala.collection.mutable.ArrayBuffer

object Icon {

  private val iconBuilder = new ClasspathResource.Builder[Icon] {
    def build(name: String, url: URL): Icon = new Icon(name, url)
  }

  def apply[C](name: String)(implicit context: Manifest[C]): Option[Icon] =
    ClasspathResource.make(context.erasure, name, iconBuilder)

  def apply(context: AnyRef, name: String): Option[Icon] =
    ClasspathResource.make(context.getClass(), name, iconBuilder)
}

class Icon(name: String, url: URL) extends ClasspathResource(name, url) {

  override def write(event: Event[_]) {

    event.write("""<img src="""")
    event.write(path)
    event.write("""" width="48px" height="48px"/>""")
  }
}