/*
 * Copyright (c) 2011, Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.html

import endea.Endea
import endea.http.Event
import endea._
import java.io.File

object ImageView {

  def write(event: Event[_], image: Option[Image]) {

    image match {
      case None =>
      case Some(image) =>
        event.write("<img src=\"")
        event.write(image.uri)

        event.write("\" height=\"")
        event.write("240px")
        event.write("\" width=\"")
        event.write("320px")

        event.write("\" />")
    }
  }
}