/*
 * Copyright (c) 2011, 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.data

import endea.data._
import endea.internal._
import endea.io._

object DataDecoder {

  def instance[D <: Data](in: ByteInput, metaData: MetaData): D = {

    val data = MetaData.newInstance().asInstanceOf[D]

    for (attribute <- metaData.attributes) {
      attribute.getType match {
        case Field.IC =>
          attribute.set(data, in.getVarInt())
        case Field.SC =>
          attribute.set(data, in.getString())
      }
    }

    data
  }
}
