/*
 * Copyright (c) 2012, Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.entity

import endea._
import endea.entity._
import endea.value._
import java.lang.reflect.Field
import java.lang.reflect.Constructor

class Attribute(val id: Int, 
    // val while needed by serial for annotation
    val field: Field) {

  field.setAccessible(true)

  lazy val name = field.getName()

  val getType = field.getType()

  lazy val index: Option[Index[Any, Entity]] = {

    if (classOf[Entity].isAssignableFrom(field.getType()))
      Some(new EntityIndex[Entity, Entity](id.toHexString).asInstanceOf[Index[Any, Entity]])
    else {
      val annotation = field.getAnnotation(classOf[Indexed])
      if (annotation == null)
        None
      else {

        val ptype = field.getAnnotation(classOf[PType])
        if (ptype == null)
          throw new Exception("Declare @PType to " + field)
        val clazz = ptype.value()
        if (classOf[Entity].isAssignableFrom(clazz))
          Some(new EntityIndex[Entity, Entity](id.toHexString).asInstanceOf[Index[Any, Entity]])
        else if (clazz == classOf[String])
          Some(new StringIndex[Entity](id.toHexString).asInstanceOf[Index[Any, Entity]])
        else
          None
      }
    }
  }

  val isValue: Boolean = {

    if (classOf[Value[_]].isAssignableFrom(getType))
      true
    else {
      val pType = field.getAnnotation(classOf[PType])
      if (pType == null)
        false
      else
        classOf[Value[_]].isAssignableFrom(pType.value)
    }

  }

  def get(entity: Entity) = field.get(entity)

  def set(entity: Entity, value: Any) = field.set(entity, value)

  override def equals(that: Any) = that match {
    case att: Attribute => id == att.id
    case _ => false
  }

  override def hashCode() = id

  override def toString() = field.getName
}