/*
 * Copyright (c) 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.entity

import endea.Endea
import endea.Entity
import endea.io.File
import endea.Entity.Deleted

import scala.collection.mutable.WeakHashMap

import java.nio.channels.AsynchronousFileChannel
import java.nio.ByteBuffer
import java.util.concurrent.atomic.AtomicLong

object EntityStore {

  val cache = new WeakHashMap[Long, Entity]

  lazy val status = {
    val field = classOf[Entity].getDeclaredField("status")
    field.setAccessible(true)
    field
  }

  def delete(entity: Entity) {

    //getFile(entity.id).moveTo(trash)
    status.set(entity, Deleted)
    cache -= entity.id
    //TODO remove from indexs
  }

  def clear() {

    FileHandler.directory.delete
    Index.indexDir.delete

  }

  //  private def _get(id: Long) {
  //
  //    val file = getFile(id)
  //
  //    val channel = AsynchronousFileChannel.open(file.jFile.toPath)
  //    val buffer = ByteBuffer.allocate(1024)
  //
  //    val future = channel.read(buffer, 0)
  //  }
}