/*
 * Copyright (c) 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.entity

import endea._
import io.ByteInput
import io.ByteOutput

object FileHandler {

  val directory = (Endea.path \\ "entity") make

  private var digits = Array[Char]('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f')

}

class FileHandler(val id: Long) {

  val path = {

    val builder = new StringBuilder()
    for (i <- 60 to 0 by -4) {
      builder += FileHandler.digits(((id >>> i) & 0xF).asInstanceOf[Int])
      if (i != 0 && (i % 12) == 0)
        builder += '/'
    }
    builder.toString()
  }

  def get() {

  }

  val link = FileHandler.directory >\ (path + ".ent")

  def exists() = link.exists

  def read(f: ByteInput => Unit) = link.read(f)

  def write(f: ByteOutput => Unit) {

    if (!link.exists) {

      val file = FileHandler.directory \ (path + ".1.ent")
      file.write(f)
      link.make(file)
    }
  }
}