/*
 * Copyright (c) 2011, 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.entity

import endea._

object Get {

  def get[E <: Entity](id: Long)(implicit manifest: Manifest[E]): Option[E] = {

    //val cMf = ClassManifest.fromClass(classOf[Entity])
    //val nothing = Manifest.Nothing

    def filter(some: Some[_]) = {
      if (manifest.erasure.isAssignableFrom(some.get.getClass()))
        some.asInstanceOf[Some[E]]
      else
        None
    }

    EntityStore.cache.get(id) match {
      case some: Some[_] => filter(some)
      case None =>

        val handler = new FileHandler(id)
        if (handler.exists) {

          var entity: Entity = null
          handler.read(input => entity = Serial.read(input))
          EntityStore.cache.put(entity.id, entity)
          filter(Some(entity))

        } else None
    }
  }
}