/*
 * Copyright (c) 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.entity

import endea.io._
import java.util.concurrent.atomic.AtomicLong

// TODO move to FileHandler ??
object Sequence {

  private lazy val sequence: AtomicLong = new AtomicLong(findMaxId())

  def next(): Long = sequence.getAndIncrement()

  private[entity] def findMaxId(): Long = {

    val directory = FileHandler.directory
    if (!directory.exists() || directory.isEmpty())
      1
    else {
      val builder = new StringBuilder()
      rec(directory, builder)
      java.lang.Long.parseLong(builder.toString, 16) + 1
    }
  }

  private def rec(directory: Directory, builder: StringBuilder) {

    val list: Array[String] = directory.list()
    if (list.isEmpty)
      throw new Exception("File not found: " + directory)
    else {
      directory ?\ list.max match {
        case dir: Directory =>
          builder ++= dir.name
          rec(dir, builder)
        case file: File =>
          builder ++= file.name.dropRight(4)
      }
    }
  }
}