/*
 * Copyright 2011 Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.html

import endea._
import endea.html._
import endea.http.Event

object DocumentAction extends HtmlAction[Document] {

  val css = None
  val js = None

  override def write(event: Event[Document]) {

    val document = event.entity

    event.write("<h2>")
    event.write(document.name)
    event.write("</h2>")

    if (document.text != null)
      event.write(document.text)
  }
}