/*
 * Copyright (c) 2012, Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.io

import endea.io._
import scala.collection.mutable._
import java.io.OutputStream
import java.io.InputStream
import java.io.FileOutputStream

class ByteArrayBufferEnhancer(buffer: ArrayBuffer[Byte]) extends OutputStream {

  override def write(int: Int) {
    buffer += int.asInstanceOf[Byte]
  }

  def openStream(): InputStream = new ArrayInputStream()

  def copyTo(out: OutputStream) {

    try {
      out.write(buffer.toArray)
    } finally {
      Utils.close(out)
    }
  }

  def copyTo(file: File) {
    copyTo(new FileOutputStream(file.jFile))
  }

  private class ArrayInputStream extends InputStream {

    var index = -1

    override def read(): Int = {

      index += 1

      if (index < buffer.size)
        buffer(index) & 0xff
      else
        -1
    }

    //    override def read(array: Array[Byte], off: Int, len: Int) {
    //
    //      if (off < 0 || len < 0 || len > array.length - off)
    //        throw new IndexOutOfBoundsException();
    //
    //      if (index >= buffer.size)
    //        -1
    //      else {
    //
    //        val avail = buffer.size - index
    //        if (len > avail) {
    //          len = avail;
    //        }
    //
    //        if (len <= 0) {
    //          0
    //        } else {
    //          System.arraycopy(buffer, index, array, off, len)
    //          index += len
    //          len
    //        }
    //      }
    //    }

    override def available() = buffer.size - index
  }
}