/*
 * Copyright (c) 2012, Endea
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.io

import endea.io._
import java.io.InputStream
import java.io.OutputStream

import java.nio.file._

import java.util.zip.CRC32

class InputStreamEnhancer(self: InputStream) {

  def copyTo(file: File) {
    copyTo(file.toOutputStream())
  }

  def copyTo(out: OutputStream) {

    try {
      val buffer = new Array[Byte](4096)
      Stream.continually(self.read(buffer)).
        takeWhile(_ != -1).
        foreach(out.write(buffer, 0, _))

        out.flush()
      //      var bytes = self.read(buffer)
      //      while (bytes != -1) {
      //        out.write(buffer, 0, bytes)
      //        bytes = self.read(buffer)
      //      }
      //      out.flush()

    } finally {
      Utils.close(self)
      Utils.close(out)
    }
  }

  def crc(): Long = {

    val crc32 = new CRC32()

    try {
      val buffer = new Array[Byte](512)
      Stream.continually(self.read(buffer)).
        takeWhile(_ != -1).
        foreach(crc32.update(buffer, 0, _))
    } finally {
      Utils.close(self)
    }

    crc32.getValue()
  }
}