/*
 * Copyright (c) 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.io

import java.io.{ File => JFile, _ }
import java.nio.file.Files

class Link private[io] (jFile: JFile) extends Path(jFile) {

  def make(file: File) {
    Files.createLink(jFile.toPath, file.path)

  }

  def read(f: ByteInput => Unit) = new File(jFile).read(f)
}