/*
 * Copyright (c) 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.io

import endea.internal.io.ByteArrayBufferEnhancer
import endea.internal.io.ByteArrayEnhancer
import endea.internal.io.InputStreamEnhancer
import endea.internal.io.URLEnhancer

import scala.collection.mutable.ArrayBuffer

import java.io.InputStream
import java.net.URL
import java.nio.file.Files

package object io {

  def \\(name: String) = Directory.userDir \\ name

  def \(name: String) = Directory.userDir \ name

  def %\ = new File(Files.createTempFile(null, null).toFile())

  implicit def enhance(array: Array[Byte]) = new ByteArrayEnhancer(array)

  implicit def enhance(arrayBuffer: ArrayBuffer[Byte]) = new ByteArrayBufferEnhancer(arrayBuffer)

  implicit def enhance(inputStream: InputStream) = new InputStreamEnhancer(inputStream)

  implicit def enhance(url: URL) = new URLEnhancer(url)

}