/*
 * Copyright (c) 2012, Endea.org
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.task

import java.util.concurrent.TimeUnit

object Interval {
  def apply(duration: Long, unit: TimeUnit) = new Interval(duration, unit)

  implicit def int2interval(int: Int) = new RichLong(int.toLong)
  implicit def long2interval(long: Long) = new RichLong(long)

  class RichLong(long: Long) {
    def nanos = Interval(long, TimeUnit.NANOSECONDS)
    def micros = Interval(long, TimeUnit.MICROSECONDS)
    def millis = Interval(long, TimeUnit.MILLISECONDS)
    def second = Interval(long, TimeUnit.SECONDS)
    def seconds = Interval(long, TimeUnit.SECONDS)
    def minute = Interval(long, TimeUnit.MINUTES)
    def minutes = Interval(long, TimeUnit.MINUTES)
    def hours = Interval(long, TimeUnit.HOURS)
    def days = Interval(long, TimeUnit.DAYS)
  }
}

class Interval(val duration: Long, val unit: TimeUnit)