/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.UriParser;

public class LocalFileName
extends AbstractFileName {
    private static final char[] RESERVED_URI_CHARS = new char[]{'#'};
    private final String rootFile;

    protected LocalFileName(String string, String string2, String string3, FileType fileType) {
        super(string, string3, fileType);
        this.rootFile = string2.intern();
    }

    public String getRootFile() {
        return this.rootFile;
    }

    @Override
    public FileName createName(String string, FileType fileType) {
        return new LocalFileName(this.getScheme(), this.rootFile, string, fileType);
    }

    @Override
    public String getURI() {
        String string = super.getURI();
        if (string != null && string.length() > 0) {
            try {
                string = UriParser.decode((String)string);
                string = UriParser.encode((String)string, (char[])RESERVED_URI_CHARS);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public String getFriendlyURI() {
        String string = super.getFriendlyURI();
        if (string != null && string.length() > 0) {
            try {
                string = UriParser.decode((String)string);
                string = UriParser.encode((String)string, (char[])RESERVED_URI_CHARS);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public String toString() {
        try {
            return UriParser.decode((String)super.getURI());
        }
        catch (FileSystemException fileSystemException) {
            return super.getURI();
        }
    }

    @Override
    protected void appendRootUri(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(this.getScheme());
        stringBuilder.append("://");
        stringBuilder.append(this.rootFile);
    }
}

