/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.jar;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.jar.JarFileSystem;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;
import org.apache.commons.vfs2.provider.zip.ZipFileSystem;

public class JarFileObject
extends ZipFileObject {
    private final JarFileSystem fs;
    private static final ConcurrentHashMap<Attributes, Attributes> ATTRIBUTES_INTERN = new ConcurrentHashMap();
    private static final Attributes EMPTY_ATTRIBUTES = new Attributes(1);
    private Attributes attributes;

    private static Attributes cached(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        Attributes attributes2 = ATTRIBUTES_INTERN.putIfAbsent(attributes, attributes);
        if (attributes2 != null) {
            return attributes2;
        }
        return attributes;
    }

    protected JarFileObject(AbstractFileName abstractFileName, ZipEntry zipEntry, JarFileSystem jarFileSystem, boolean bl) throws FileSystemException {
        super(abstractFileName, zipEntry, (ZipFileSystem)jarFileSystem, bl);
        this.fs = jarFileSystem;
        try {
            this.getAttributes();
        }
        catch (IOException iOException) {
            throw new FileSystemException((Throwable)iOException);
        }
    }

    Manifest getManifest() throws IOException {
        if (this.fs.getZipFile() == null) {
            return null;
        }
        return ((JarFile)this.fs.getZipFile()).getManifest();
    }

    Attributes getAttributes() throws IOException {
        if (this.attributes == null) {
            if (this.entry == null) {
                this.attributes = EMPTY_ATTRIBUTES;
            } else {
                this.attributes = ((JarEntry)this.entry).getAttributes();
                if (this.attributes == null) {
                    this.attributes = EMPTY_ATTRIBUTES;
                }
            }
        }
        return JarFileObject.cached(this.attributes);
    }

    protected Map<String, Object> doGetAttributes() throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        JarFileSystem jarFileSystem = (JarFileSystem)this.getFileSystem();
        this.addAll(jarFileSystem.getAttributes(), hashMap);
        this.addAll(this.getAttributes(), hashMap);
        return hashMap;
    }

    private void addAll(Attributes attributes, Map<String, Object> map) {
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String string = entry.getKey().toString();
            map.put(string, entry.getValue());
        }
    }

    protected Certificate[] doGetCertificates() {
        if (this.entry == null) {
            return null;
        }
        return ((JarEntry)this.entry).getCertificates();
    }
}

