/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.InputStream;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.zip.ZipFileSystem;

public class ZipFileObject
extends AbstractFileObject<ZipFileSystem> {
    protected ZipEntry entry;
    private volatile HashSet<String> children = null;
    private FileType type;

    protected ZipFileObject(AbstractFileName abstractFileName, ZipEntry zipEntry, ZipFileSystem zipFileSystem, boolean bl) throws FileSystemException {
        super(abstractFileName, (AbstractFileSystem)zipFileSystem);
        this.setZipEntry(zipEntry);
        if (!bl) {
            this.type = FileType.IMAGINARY;
        }
    }

    protected void setZipEntry(ZipEntry zipEntry) {
        if (this.entry != null) {
            return;
        }
        this.type = zipEntry == null || zipEntry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = zipEntry;
    }

    public void attachChild(FileName fileName) {
        if (this.children == null) {
            this.children = new HashSet();
        }
        this.children.add(fileName.getBaseName());
    }

    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    protected FileType doGetType() {
        return this.type;
    }

    protected String[] doListChildren() {
        try {
            if (!this.getType().hasChildren()) {
                return null;
            }
        }
        catch (FileSystemException fileSystemException) {
            throw new RuntimeException(fileSystemException);
        }
        if (this.children == null) {
            return new String[0];
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    protected long doGetContentSize() {
        return this.entry.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.entry.getTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", (Object)this.getName());
        }
        return ((ZipFileSystem)this.getAbstractFileSystem()).getZipFile().getInputStream(this.entry);
    }
}

