/*
 * Decompiled with CFR 0.152.
 */
package ensime.shaded.coursier.shaded.org.jsoup.select;

import ensime.shaded.coursier.shaded.org.jsoup.helper.Validate;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Element;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.FormElement;
import ensime.shaded.coursier.shaded.org.jsoup.select.Evaluator;
import ensime.shaded.coursier.shaded.org.jsoup.select.NodeTraversor;
import ensime.shaded.coursier.shaded.org.jsoup.select.NodeVisitor;
import ensime.shaded.coursier.shaded.org.jsoup.select.QueryParser;
import ensime.shaded.coursier.shaded.org.jsoup.select.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Elements
extends ArrayList<Element> {
    public Elements() {
    }

    public Elements(int initialCapacity) {
        super(initialCapacity);
    }

    public Elements(Collection<Element> elements) {
        super(elements);
    }

    public Elements(List<Element> elements) {
        super(elements);
    }

    public Elements(Element ... elements) {
        super(Arrays.asList(elements));
    }

    @Override
    public Elements clone() {
        Elements clone = new Elements(this.size());
        for (Element e : this) {
            clone.add(e.clone());
        }
        return clone;
    }

    public String attr(String attributeKey) {
        for (Element element2 : this) {
            if (!element2.hasAttr(attributeKey)) continue;
            return element2.attr(attributeKey);
        }
        return "";
    }

    public boolean hasAttr(String attributeKey) {
        for (Element element2 : this) {
            if (!element2.hasAttr(attributeKey)) continue;
            return true;
        }
        return false;
    }

    public Elements attr(String attributeKey, String attributeValue) {
        for (Element element2 : this) {
            element2.attr(attributeKey, attributeValue);
        }
        return this;
    }

    public Elements removeAttr(String attributeKey) {
        for (Element element2 : this) {
            element2.removeAttr(attributeKey);
        }
        return this;
    }

    public Elements addClass(String className) {
        for (Element element2 : this) {
            element2.addClass(className);
        }
        return this;
    }

    public Elements removeClass(String className) {
        for (Element element2 : this) {
            element2.removeClass(className);
        }
        return this;
    }

    public Elements toggleClass(String className) {
        for (Element element2 : this) {
            element2.toggleClass(className);
        }
        return this;
    }

    public boolean hasClass(String className) {
        for (Element element2 : this) {
            if (!element2.hasClass(className)) continue;
            return true;
        }
        return false;
    }

    public String val() {
        if (this.size() > 0) {
            return this.first().val();
        }
        return "";
    }

    public Elements val(String value2) {
        for (Element element2 : this) {
            element2.val(value2);
        }
        return this;
    }

    public String text() {
        StringBuilder sb = new StringBuilder();
        for (Element element2 : this) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(element2.text());
        }
        return sb.toString();
    }

    public boolean hasText() {
        for (Element element2 : this) {
            if (!element2.hasText()) continue;
            return true;
        }
        return false;
    }

    public String html() {
        StringBuilder sb = new StringBuilder();
        for (Element element2 : this) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(element2.html());
        }
        return sb.toString();
    }

    public String outerHtml() {
        StringBuilder sb = new StringBuilder();
        for (Element element2 : this) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(element2.outerHtml());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    public Elements tagName(String tagName) {
        for (Element element2 : this) {
            element2.tagName(tagName);
        }
        return this;
    }

    public Elements html(String html) {
        for (Element element2 : this) {
            element2.html(html);
        }
        return this;
    }

    public Elements prepend(String html) {
        for (Element element2 : this) {
            element2.prepend(html);
        }
        return this;
    }

    public Elements append(String html) {
        for (Element element2 : this) {
            element2.append(html);
        }
        return this;
    }

    public Elements before(String html) {
        for (Element element2 : this) {
            element2.before(html);
        }
        return this;
    }

    public Elements after(String html) {
        for (Element element2 : this) {
            element2.after(html);
        }
        return this;
    }

    public Elements wrap(String html) {
        Validate.notEmpty(html);
        for (Element element2 : this) {
            element2.wrap(html);
        }
        return this;
    }

    public Elements unwrap() {
        for (Element element2 : this) {
            element2.unwrap();
        }
        return this;
    }

    public Elements empty() {
        for (Element element2 : this) {
            element2.empty();
        }
        return this;
    }

    public Elements remove() {
        for (Element element2 : this) {
            element2.remove();
        }
        return this;
    }

    public Elements select(String query) {
        return Selector.select(query, this);
    }

    public Elements not(String query) {
        Elements out = Selector.select(query, this);
        return Selector.filterOut(this, out);
    }

    public Elements eq(int index2) {
        return this.size() > index2 ? new Elements((Element)this.get(index2)) : new Elements();
    }

    public boolean is(String query) {
        Evaluator eval2 = QueryParser.parse(query);
        for (Element e : this) {
            if (!e.is(eval2)) continue;
            return true;
        }
        return false;
    }

    public Elements next() {
        return this.siblings(null, true, false);
    }

    public Elements next(String query) {
        return this.siblings(query, true, false);
    }

    public Elements nextAll() {
        return this.siblings(null, true, true);
    }

    public Elements nextAll(String query) {
        return this.siblings(query, true, true);
    }

    public Elements prev() {
        return this.siblings(null, false, false);
    }

    public Elements prev(String query) {
        return this.siblings(query, false, false);
    }

    public Elements prevAll() {
        return this.siblings(null, false, true);
    }

    public Elements prevAll(String query) {
        return this.siblings(query, false, true);
    }

    private Elements siblings(String query, boolean next2, boolean all2) {
        Elements els = new Elements();
        Evaluator eval2 = query != null ? QueryParser.parse(query) : null;
        block0: for (Element e : this) {
            Element sib;
            while ((sib = next2 ? e.nextElementSibling() : e.previousElementSibling()) != null) {
                if (eval2 == null) {
                    els.add(sib);
                } else if (sib.is(eval2)) {
                    els.add(sib);
                }
                e = sib;
                if (all2) continue;
                continue block0;
            }
        }
        return els;
    }

    public Elements parents() {
        LinkedHashSet<Element> combo = new LinkedHashSet<Element>();
        for (Element e : this) {
            combo.addAll(e.parents());
        }
        return new Elements((Collection<Element>)combo);
    }

    public Element first() {
        return this.isEmpty() ? null : (Element)this.get(0);
    }

    public Element last() {
        return this.isEmpty() ? null : (Element)this.get(this.size() - 1);
    }

    public Elements traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        NodeTraversor traversor = new NodeTraversor(nodeVisitor);
        for (Element el : this) {
            traversor.traverse(el);
        }
        return this;
    }

    public List<FormElement> forms() {
        ArrayList<FormElement> forms = new ArrayList<FormElement>();
        for (Element el : this) {
            if (!(el instanceof FormElement)) continue;
            forms.add((FormElement)el);
        }
        return forms;
    }
}

