/*
 * Decompiled with CFR 0.152.
 */
package ensime.shaded.coursier.shaded.org.jsoup.nodes;

import ensime.shaded.coursier.shaded.org.jsoup.SerializationException;
import ensime.shaded.coursier.shaded.org.jsoup.helper.StringUtil;
import ensime.shaded.coursier.shaded.org.jsoup.helper.Validate;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Attributes;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Document;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Element;
import ensime.shaded.coursier.shaded.org.jsoup.parser.Parser;
import ensime.shaded.coursier.shaded.org.jsoup.select.Elements;
import ensime.shaded.coursier.shaded.org.jsoup.select.NodeTraversor;
import ensime.shaded.coursier.shaded.org.jsoup.select.NodeVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements Cloneable {
    private static final List<Node> EMPTY_NODES = Collections.emptyList();
    Node parentNode;
    List<Node> childNodes;
    Attributes attributes;
    String baseUri;
    int siblingIndex;

    protected Node(String baseUri, Attributes attributes) {
        Validate.notNull(baseUri);
        Validate.notNull(attributes);
        this.childNodes = EMPTY_NODES;
        this.baseUri = baseUri.trim();
        this.attributes = attributes;
    }

    protected Node(String baseUri) {
        this(baseUri, new Attributes());
    }

    protected Node() {
        this.childNodes = EMPTY_NODES;
        this.attributes = null;
    }

    public abstract String nodeName();

    public String attr(String attributeKey) {
        Validate.notNull(attributeKey);
        String val = this.attributes.getIgnoreCase(attributeKey);
        if (val.length() > 0) {
            return val;
        }
        if (attributeKey.toLowerCase().startsWith("abs:")) {
            return this.absUrl(attributeKey.substring("abs:".length()));
        }
        return "";
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public Node attr(String attributeKey, String attributeValue) {
        this.attributes.put(attributeKey, attributeValue);
        return this;
    }

    public boolean hasAttr(String attributeKey) {
        String key;
        Validate.notNull(attributeKey);
        if (attributeKey.startsWith("abs:") && this.attributes.hasKeyIgnoreCase(key = attributeKey.substring("abs:".length())) && !this.absUrl(key).equals("")) {
            return true;
        }
        return this.attributes.hasKeyIgnoreCase(attributeKey);
    }

    public Node removeAttr(String attributeKey) {
        Validate.notNull(attributeKey);
        this.attributes.removeIgnoreCase(attributeKey);
        return this;
    }

    public String baseUri() {
        return this.baseUri;
    }

    public void setBaseUri(final String baseUri) {
        Validate.notNull(baseUri);
        this.traverse(new NodeVisitor(){

            public void head(Node node4, int depth) {
                node4.baseUri = baseUri;
            }

            public void tail(Node node4, int depth) {
            }
        });
    }

    public String absUrl(String attributeKey) {
        Validate.notEmpty(attributeKey);
        if (!this.hasAttr(attributeKey)) {
            return "";
        }
        return StringUtil.resolve(this.baseUri, this.attr(attributeKey));
    }

    public Node childNode(int index2) {
        return this.childNodes.get(index2);
    }

    public List<Node> childNodes() {
        return Collections.unmodifiableList(this.childNodes);
    }

    public List<Node> childNodesCopy() {
        ArrayList<Node> children2 = new ArrayList<Node>(this.childNodes.size());
        for (Node node4 : this.childNodes) {
            children2.add(node4.clone());
        }
        return children2;
    }

    public final int childNodeSize() {
        return this.childNodes.size();
    }

    protected Node[] childNodesAsArray() {
        return this.childNodes.toArray(new Node[this.childNodeSize()]);
    }

    public Node parent() {
        return this.parentNode;
    }

    public final Node parentNode() {
        return this.parentNode;
    }

    public Node root() {
        Node node4 = this;
        while (node4.parentNode != null) {
            node4 = node4.parentNode;
        }
        return node4;
    }

    public Document ownerDocument() {
        Node root = this.root();
        return root instanceof Document ? (Document)root : null;
    }

    public void remove() {
        Validate.notNull(this.parentNode);
        this.parentNode.removeChild(this);
    }

    public Node before(String html) {
        this.addSiblingHtml(this.siblingIndex, html);
        return this;
    }

    public Node before(Node node4) {
        Validate.notNull(node4);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex, node4);
        return this;
    }

    public Node after(String html) {
        this.addSiblingHtml(this.siblingIndex + 1, html);
        return this;
    }

    public Node after(Node node4) {
        Validate.notNull(node4);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex + 1, node4);
        return this;
    }

    private void addSiblingHtml(int index2, String html) {
        Validate.notNull(html);
        Validate.notNull(this.parentNode);
        Element context = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> nodes = Parser.parseFragment(html, context, this.baseUri());
        this.parentNode.addChildren(index2, nodes.toArray(new Node[nodes.size()]));
    }

    public Node wrap(String html) {
        Validate.notEmpty(html);
        Element context = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> wrapChildren = Parser.parseFragment(html, context, this.baseUri());
        Node wrapNode = wrapChildren.get(0);
        if (wrapNode == null || !(wrapNode instanceof Element)) {
            return null;
        }
        Element wrap = (Element)wrapNode;
        Element deepest = this.getDeepChild(wrap);
        this.parentNode.replaceChild(this, wrap);
        deepest.addChildren(this);
        if (wrapChildren.size() > 0) {
            for (int i = 0; i < wrapChildren.size(); ++i) {
                Node remainder = wrapChildren.get(i);
                remainder.parentNode.removeChild(remainder);
                wrap.appendChild(remainder);
            }
        }
        return this;
    }

    public Node unwrap() {
        Validate.notNull(this.parentNode);
        Node firstChild = this.childNodes.size() > 0 ? this.childNodes.get(0) : null;
        this.parentNode.addChildren(this.siblingIndex, this.childNodesAsArray());
        this.remove();
        return firstChild;
    }

    private Element getDeepChild(Element el) {
        Elements children2 = el.children();
        if (children2.size() > 0) {
            return this.getDeepChild((Element)children2.get(0));
        }
        return el;
    }

    public void replaceWith(Node in) {
        Validate.notNull(in);
        Validate.notNull(this.parentNode);
        this.parentNode.replaceChild(this, in);
    }

    protected void setParentNode(Node parentNode) {
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
        }
        this.parentNode = parentNode;
    }

    protected void replaceChild(Node out, Node in) {
        Validate.isTrue(out.parentNode == this);
        Validate.notNull(in);
        if (in.parentNode != null) {
            in.parentNode.removeChild(in);
        }
        int index2 = out.siblingIndex;
        this.childNodes.set(index2, in);
        in.parentNode = this;
        in.setSiblingIndex(index2);
        out.parentNode = null;
    }

    protected void removeChild(Node out) {
        Validate.isTrue(out.parentNode == this);
        int index2 = out.siblingIndex;
        this.childNodes.remove(index2);
        this.reindexChildren(index2);
        out.parentNode = null;
    }

    protected void addChildren(Node ... children2) {
        for (Node child : children2) {
            this.reparentChild(child);
            this.ensureChildNodes();
            this.childNodes.add(child);
            child.setSiblingIndex(this.childNodes.size() - 1);
        }
    }

    protected void addChildren(int index2, Node ... children2) {
        Validate.noNullElements(children2);
        this.ensureChildNodes();
        for (int i = children2.length - 1; i >= 0; --i) {
            Node in = children2[i];
            this.reparentChild(in);
            this.childNodes.add(index2, in);
            this.reindexChildren(index2);
        }
    }

    protected void ensureChildNodes() {
        if (this.childNodes == EMPTY_NODES) {
            this.childNodes = new ArrayList<Node>(4);
        }
    }

    protected void reparentChild(Node child) {
        if (child.parentNode != null) {
            child.parentNode.removeChild(child);
        }
        child.setParentNode(this);
    }

    private void reindexChildren(int start) {
        for (int i = start; i < this.childNodes.size(); ++i) {
            this.childNodes.get(i).setSiblingIndex(i);
        }
    }

    public List<Node> siblingNodes() {
        if (this.parentNode == null) {
            return Collections.emptyList();
        }
        List<Node> nodes = this.parentNode.childNodes;
        ArrayList<Node> siblings = new ArrayList<Node>(nodes.size() - 1);
        for (Node node4 : nodes) {
            if (node4 == this) continue;
            siblings.add(node4);
        }
        return siblings;
    }

    public Node nextSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Node> siblings = this.parentNode.childNodes;
        int index2 = this.siblingIndex + 1;
        if (siblings.size() > index2) {
            return siblings.get(index2);
        }
        return null;
    }

    public Node previousSibling() {
        if (this.parentNode == null) {
            return null;
        }
        if (this.siblingIndex > 0) {
            return this.parentNode.childNodes.get(this.siblingIndex - 1);
        }
        return null;
    }

    public int siblingIndex() {
        return this.siblingIndex;
    }

    protected void setSiblingIndex(int siblingIndex) {
        this.siblingIndex = siblingIndex;
    }

    public Node traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        NodeTraversor traversor = new NodeTraversor(nodeVisitor);
        traversor.traverse(this);
        return this;
    }

    public String outerHtml() {
        StringBuilder accum = new StringBuilder(128);
        this.outerHtml(accum);
        return accum.toString();
    }

    protected void outerHtml(Appendable accum) {
        new NodeTraversor(new OuterHtmlVisitor(accum, this.getOutputSettings())).traverse(this);
    }

    Document.OutputSettings getOutputSettings() {
        Document owner = this.ownerDocument();
        return owner != null ? owner.outputSettings() : new Document("").outputSettings();
    }

    abstract void outerHtmlHead(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    abstract void outerHtmlTail(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    public <T extends Appendable> T html(T appendable) {
        this.outerHtml(appendable);
        return appendable;
    }

    public String toString() {
        return this.outerHtml();
    }

    protected void indent(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        accum.append("\n").append(StringUtil.padding(depth * out.indentAmount()));
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public boolean hasSameValue(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.outerHtml().equals(((Node)o).outerHtml());
    }

    public Node clone() {
        Node thisClone = this.doClone(null);
        LinkedList<Node> nodesToProcess = new LinkedList<Node>();
        nodesToProcess.add(thisClone);
        while (!nodesToProcess.isEmpty()) {
            Node currParent = (Node)nodesToProcess.remove();
            for (int i = 0; i < currParent.childNodes.size(); ++i) {
                Node childClone = currParent.childNodes.get(i).doClone(currParent);
                currParent.childNodes.set(i, childClone);
                nodesToProcess.add(childClone);
            }
        }
        return thisClone;
    }

    protected Node doClone(Node parent2) {
        Node clone;
        try {
            clone = (Node)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.parentNode = parent2;
        clone.siblingIndex = parent2 == null ? 0 : this.siblingIndex;
        clone.attributes = this.attributes != null ? this.attributes.clone() : null;
        clone.baseUri = this.baseUri;
        clone.childNodes = new ArrayList<Node>(this.childNodes.size());
        for (Node child : this.childNodes) {
            clone.childNodes.add(child);
        }
        return clone;
    }

    private static class OuterHtmlVisitor
    implements NodeVisitor {
        private Appendable accum;
        private Document.OutputSettings out;

        OuterHtmlVisitor(Appendable accum, Document.OutputSettings out) {
            this.accum = accum;
            this.out = out;
        }

        public void head(Node node4, int depth) {
            try {
                node4.outerHtmlHead(this.accum, depth, this.out);
            }
            catch (IOException exception) {
                throw new SerializationException(exception);
            }
        }

        public void tail(Node node4, int depth) {
            if (!node4.nodeName().equals("#text")) {
                try {
                    node4.outerHtmlTail(this.accum, depth, this.out);
                }
                catch (IOException exception) {
                    throw new SerializationException(exception);
                }
            }
        }
    }
}

