/*
 * Decompiled with CFR 0.152.
 */
package ensime.shaded.coursier.shaded.org.jsoup.nodes;

import ensime.shaded.coursier.shaded.org.jsoup.helper.StringUtil;
import ensime.shaded.coursier.shaded.org.jsoup.helper.Validate;
import ensime.shaded.coursier.shaded.org.jsoup.internal.Normalizer;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Attributes;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Comment;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.DataNode;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Document;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Node;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.TextNode;
import ensime.shaded.coursier.shaded.org.jsoup.parser.ParseSettings;
import ensime.shaded.coursier.shaded.org.jsoup.parser.Parser;
import ensime.shaded.coursier.shaded.org.jsoup.parser.Tag;
import ensime.shaded.coursier.shaded.org.jsoup.select.Collector;
import ensime.shaded.coursier.shaded.org.jsoup.select.Elements;
import ensime.shaded.coursier.shaded.org.jsoup.select.Evaluator;
import ensime.shaded.coursier.shaded.org.jsoup.select.NodeTraversor;
import ensime.shaded.coursier.shaded.org.jsoup.select.NodeVisitor;
import ensime.shaded.coursier.shaded.org.jsoup.select.QueryParser;
import ensime.shaded.coursier.shaded.org.jsoup.select.Selector;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends Node {
    private Tag tag;
    private WeakReference<List<Element>> shadowChildrenRef;
    private static final Pattern classSplit = Pattern.compile("\\s+");

    public Element(String tag) {
        this(Tag.valueOf(tag), "", new Attributes());
    }

    public Element(Tag tag, String baseUri, Attributes attributes) {
        super(baseUri, attributes);
        Validate.notNull(tag);
        this.tag = tag;
    }

    public Element(Tag tag, String baseUri) {
        this(tag, baseUri, new Attributes());
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    public Element tagName(String tagName) {
        Validate.notEmpty(tagName, "Tag name must not be empty.");
        this.tag = Tag.valueOf(tagName, ParseSettings.preserveCase);
        return this;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        return this.attributes.getIgnoreCase("id");
    }

    @Override
    public Element attr(String attributeKey, String attributeValue) {
        super.attr(attributeKey, attributeValue);
        return this;
    }

    public Element attr(String attributeKey, boolean attributeValue) {
        this.attributes.put(attributeKey, attributeValue);
        return this;
    }

    public Map<String, String> dataset() {
        return this.attributes.dataset();
    }

    @Override
    public final Element parent() {
        return (Element)this.parentNode;
    }

    public Elements parents() {
        Elements parents = new Elements();
        Element.accumulateParents(this, parents);
        return parents;
    }

    private static void accumulateParents(Element el, Elements parents) {
        Element parent2 = el.parent();
        if (parent2 != null && !parent2.tagName().equals("#root")) {
            parents.add(parent2);
            Element.accumulateParents(parent2, parents);
        }
    }

    public Element child(int index2) {
        return this.childElementsList().get(index2);
    }

    public Elements children() {
        return new Elements(this.childElementsList());
    }

    private List<Element> childElementsList() {
        ArrayList<Element> children2;
        if (this.shadowChildrenRef == null || (children2 = (ArrayList<Element>)this.shadowChildrenRef.get()) == null) {
            int size2 = this.childNodes.size();
            children2 = new ArrayList<Element>(size2);
            for (int i = 0; i < size2; ++i) {
                Node node4 = (Node)this.childNodes.get(i);
                if (!(node4 instanceof Element)) continue;
                children2.add((Element)node4);
            }
            this.shadowChildrenRef = new WeakReference(children2);
        }
        return children2;
    }

    @Override
    void nodelistChanged() {
        super.nodelistChanged();
        this.shadowChildrenRef = null;
    }

    public List<TextNode> textNodes() {
        ArrayList<TextNode> textNodes = new ArrayList<TextNode>();
        for (Node node4 : this.childNodes) {
            if (!(node4 instanceof TextNode)) continue;
            textNodes.add((TextNode)node4);
        }
        return Collections.unmodifiableList(textNodes);
    }

    public List<DataNode> dataNodes() {
        ArrayList<DataNode> dataNodes = new ArrayList<DataNode>();
        for (Node node4 : this.childNodes) {
            if (!(node4 instanceof DataNode)) continue;
            dataNodes.add((DataNode)node4);
        }
        return Collections.unmodifiableList(dataNodes);
    }

    public Elements select(String cssQuery) {
        return Selector.select(cssQuery, this);
    }

    public boolean is(String cssQuery) {
        return this.is(QueryParser.parse(cssQuery));
    }

    public boolean is(Evaluator evaluator) {
        return evaluator.matches((Element)this.root(), this);
    }

    public Element appendChild(Node child) {
        Validate.notNull(child);
        this.reparentChild(child);
        this.ensureChildNodes();
        this.childNodes.add(child);
        child.setSiblingIndex(this.childNodes.size() - 1);
        return this;
    }

    public Element prependChild(Node child) {
        Validate.notNull(child);
        this.addChildren(0, child);
        return this;
    }

    public Element insertChildren(int index2, Collection<? extends Node> children2) {
        Validate.notNull(children2, "Children collection to be inserted must not be null.");
        int currentSize = this.childNodeSize();
        if (index2 < 0) {
            index2 += currentSize + 1;
        }
        Validate.isTrue(index2 >= 0 && index2 <= currentSize, "Insert position out of bounds.");
        ArrayList<? extends Node> nodes = new ArrayList<Node>(children2);
        Node[] nodeArray = nodes.toArray(new Node[nodes.size()]);
        this.addChildren(index2, nodeArray);
        return this;
    }

    public Element insertChildren(int index2, Node ... children2) {
        Validate.notNull(children2, "Children collection to be inserted must not be null.");
        int currentSize = this.childNodeSize();
        if (index2 < 0) {
            index2 += currentSize + 1;
        }
        Validate.isTrue(index2 >= 0 && index2 <= currentSize, "Insert position out of bounds.");
        this.addChildren(index2, children2);
        return this;
    }

    public Element appendElement(String tagName) {
        Element child = new Element(Tag.valueOf(tagName), this.baseUri());
        this.appendChild(child);
        return child;
    }

    public Element prependElement(String tagName) {
        Element child = new Element(Tag.valueOf(tagName), this.baseUri());
        this.prependChild(child);
        return child;
    }

    public Element appendText(String text2) {
        Validate.notNull(text2);
        TextNode node4 = new TextNode(text2, this.baseUri());
        this.appendChild(node4);
        return this;
    }

    public Element prependText(String text2) {
        Validate.notNull(text2);
        TextNode node4 = new TextNode(text2, this.baseUri());
        this.prependChild(node4);
        return this;
    }

    public Element append(String html) {
        Validate.notNull(html);
        List<Node> nodes = Parser.parseFragment(html, this, this.baseUri());
        this.addChildren(nodes.toArray(new Node[nodes.size()]));
        return this;
    }

    public Element prepend(String html) {
        Validate.notNull(html);
        List<Node> nodes = Parser.parseFragment(html, this, this.baseUri());
        this.addChildren(0, nodes.toArray(new Node[nodes.size()]));
        return this;
    }

    @Override
    public Element before(String html) {
        return (Element)super.before(html);
    }

    @Override
    public Element before(Node node4) {
        return (Element)super.before(node4);
    }

    @Override
    public Element after(String html) {
        return (Element)super.after(html);
    }

    @Override
    public Element after(Node node4) {
        return (Element)super.after(node4);
    }

    public Element empty() {
        this.childNodes.clear();
        return this;
    }

    @Override
    public Element wrap(String html) {
        return (Element)super.wrap(html);
    }

    public String cssSelector() {
        if (this.id().length() > 0) {
            return "#" + this.id();
        }
        String tagName = this.tagName().replace(':', '|');
        StringBuilder selector = new StringBuilder(tagName);
        String classes = StringUtil.join(this.classNames(), ".");
        if (classes.length() > 0) {
            selector.append('.').append(classes);
        }
        if (this.parent() == null || this.parent() instanceof Document) {
            return selector.toString();
        }
        selector.insert(0, " > ");
        if (this.parent().select(selector.toString()).size() > 1) {
            selector.append(String.format(":nth-child(%d)", this.elementSiblingIndex() + 1));
        }
        return this.parent().cssSelector() + selector.toString();
    }

    public Elements siblingElements() {
        if (this.parentNode == null) {
            return new Elements(0);
        }
        List<Element> elements = this.parent().childElementsList();
        Elements siblings = new Elements(elements.size() - 1);
        for (Element el : elements) {
            if (el == this) continue;
            siblings.add(el);
        }
        return siblings;
    }

    public Element nextElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Element> siblings = this.parent().childElementsList();
        Integer index2 = Element.indexInList(this, siblings);
        Validate.notNull(index2);
        if (siblings.size() > index2 + 1) {
            return siblings.get(index2 + 1);
        }
        return null;
    }

    public Element previousElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Element> siblings = this.parent().childElementsList();
        Integer index2 = Element.indexInList(this, siblings);
        Validate.notNull(index2);
        if (index2 > 0) {
            return siblings.get(index2 - 1);
        }
        return null;
    }

    public Element firstElementSibling() {
        List<Element> siblings = this.parent().childElementsList();
        return siblings.size() > 1 ? siblings.get(0) : null;
    }

    public int elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().childElementsList());
    }

    public Element lastElementSibling() {
        List<Element> siblings = this.parent().childElementsList();
        return siblings.size() > 1 ? siblings.get(siblings.size() - 1) : null;
    }

    private static <E extends Element> int indexInList(Element search, List<E> elements) {
        for (int i = 0; i < elements.size(); ++i) {
            if (elements.get(i) != search) continue;
            return i;
        }
        return 0;
    }

    public Elements getElementsByTag(String tagName) {
        Validate.notEmpty(tagName);
        tagName = Normalizer.normalize(tagName);
        return Collector.collect(new Evaluator.Tag(tagName), this);
    }

    public Element getElementById(String id2) {
        Validate.notEmpty(id2);
        Elements elements = Collector.collect(new Evaluator.Id(id2), this);
        if (elements.size() > 0) {
            return (Element)elements.get(0);
        }
        return null;
    }

    public Elements getElementsByClass(String className) {
        Validate.notEmpty(className);
        return Collector.collect(new Evaluator.Class(className), this);
    }

    public Elements getElementsByAttribute(String key) {
        Validate.notEmpty(key);
        key = key.trim();
        return Collector.collect(new Evaluator.Attribute(key), this);
    }

    public Elements getElementsByAttributeStarting(String keyPrefix) {
        Validate.notEmpty(keyPrefix);
        keyPrefix = keyPrefix.trim();
        return Collector.collect(new Evaluator.AttributeStarting(keyPrefix), this);
    }

    public Elements getElementsByAttributeValue(String key, String value2) {
        return Collector.collect(new Evaluator.AttributeWithValue(key, value2), this);
    }

    public Elements getElementsByAttributeValueNot(String key, String value2) {
        return Collector.collect(new Evaluator.AttributeWithValueNot(key, value2), this);
    }

    public Elements getElementsByAttributeValueStarting(String key, String valuePrefix) {
        return Collector.collect(new Evaluator.AttributeWithValueStarting(key, valuePrefix), this);
    }

    public Elements getElementsByAttributeValueEnding(String key, String valueSuffix) {
        return Collector.collect(new Evaluator.AttributeWithValueEnding(key, valueSuffix), this);
    }

    public Elements getElementsByAttributeValueContaining(String key, String match) {
        return Collector.collect(new Evaluator.AttributeWithValueContaining(key, match), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, Pattern pattern) {
        return Collector.collect(new Evaluator.AttributeWithValueMatching(key, pattern), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsByAttributeValueMatching(key, pattern);
    }

    public Elements getElementsByIndexLessThan(int index2) {
        return Collector.collect(new Evaluator.IndexLessThan(index2), this);
    }

    public Elements getElementsByIndexGreaterThan(int index2) {
        return Collector.collect(new Evaluator.IndexGreaterThan(index2), this);
    }

    public Elements getElementsByIndexEquals(int index2) {
        return Collector.collect(new Evaluator.IndexEquals(index2), this);
    }

    public Elements getElementsContainingText(String searchText) {
        return Collector.collect(new Evaluator.ContainsText(searchText), this);
    }

    public Elements getElementsContainingOwnText(String searchText) {
        return Collector.collect(new Evaluator.ContainsOwnText(searchText), this);
    }

    public Elements getElementsMatchingText(Pattern pattern) {
        return Collector.collect(new Evaluator.Matches(pattern), this);
    }

    public Elements getElementsMatchingText(String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsMatchingText(pattern);
    }

    public Elements getElementsMatchingOwnText(Pattern pattern) {
        return Collector.collect(new Evaluator.MatchesOwn(pattern), this);
    }

    public Elements getElementsMatchingOwnText(String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsMatchingOwnText(pattern);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    public String text() {
        final StringBuilder accum = new StringBuilder();
        new NodeTraversor(new NodeVisitor(){

            public void head(Node node4, int depth) {
                if (node4 instanceof TextNode) {
                    TextNode textNode = (TextNode)node4;
                    Element.appendNormalisedText(accum, textNode);
                } else if (node4 instanceof Element) {
                    Element element2 = (Element)node4;
                    if (accum.length() > 0 && (element2.isBlock() || element2.tag.getName().equals("br")) && !TextNode.lastCharIsWhitespace(accum)) {
                        accum.append(" ");
                    }
                }
            }

            public void tail(Node node4, int depth) {
            }
        }).traverse(this);
        return accum.toString().trim();
    }

    public String ownText() {
        StringBuilder sb = new StringBuilder();
        this.ownText(sb);
        return sb.toString().trim();
    }

    private void ownText(StringBuilder accum) {
        for (Node child : this.childNodes) {
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                Element.appendNormalisedText(accum, textNode);
                continue;
            }
            if (!(child instanceof Element)) continue;
            Element.appendWhitespaceIfBr((Element)child, accum);
        }
    }

    private static void appendNormalisedText(StringBuilder accum, TextNode textNode) {
        String text2 = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.parentNode)) {
            accum.append(text2);
        } else {
            StringUtil.appendNormalisedWhitespace(accum, text2, TextNode.lastCharIsWhitespace(accum));
        }
    }

    private static void appendWhitespaceIfBr(Element element2, StringBuilder accum) {
        if (element2.tag.getName().equals("br") && !TextNode.lastCharIsWhitespace(accum)) {
            accum.append(" ");
        }
    }

    static boolean preserveWhitespace(Node node4) {
        if (node4 != null && node4 instanceof Element) {
            Element element2 = (Element)node4;
            return element2.tag.preserveWhitespace() || element2.parent() != null && element2.parent().tag.preserveWhitespace();
        }
        return false;
    }

    public Element text(String text2) {
        Validate.notNull(text2);
        this.empty();
        TextNode textNode = new TextNode(text2, this.baseUri);
        this.appendChild(textNode);
        return this;
    }

    public boolean hasText() {
        for (Node child : this.childNodes) {
            Element el;
            TextNode textNode;
            if (!(child instanceof TextNode ? !(textNode = (TextNode)child).isBlank() : child instanceof Element && (el = (Element)child).hasText())) continue;
            return true;
        }
        return false;
    }

    public String data() {
        StringBuilder sb = new StringBuilder();
        for (Node childNode : this.childNodes) {
            if (childNode instanceof DataNode) {
                DataNode data = (DataNode)childNode;
                sb.append(data.getWholeData());
                continue;
            }
            if (childNode instanceof Comment) {
                Comment comment = (Comment)childNode;
                sb.append(comment.getData());
                continue;
            }
            if (!(childNode instanceof Element)) continue;
            Element element2 = (Element)childNode;
            String elementData = element2.data();
            sb.append(elementData);
        }
        return sb.toString();
    }

    public String className() {
        return this.attr("class").trim();
    }

    public Set<String> classNames() {
        String[] names = classSplit.split(this.className());
        LinkedHashSet<String> classNames = new LinkedHashSet<String>(Arrays.asList(names));
        classNames.remove("");
        return classNames;
    }

    public Element classNames(Set<String> classNames) {
        Validate.notNull(classNames);
        this.attributes.put("class", StringUtil.join(classNames, " "));
        return this;
    }

    public boolean hasClass(String className) {
        String classAttr = this.attributes.getIgnoreCase("class");
        int len = classAttr.length();
        int wantLen = className.length();
        if (len == 0 || len < wantLen) {
            return false;
        }
        if (len == wantLen) {
            return className.equalsIgnoreCase(classAttr);
        }
        boolean inClass = false;
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(classAttr.charAt(i))) {
                if (!inClass) continue;
                if (i - start == wantLen && classAttr.regionMatches(true, start, className, 0, wantLen)) {
                    return true;
                }
                inClass = false;
                continue;
            }
            if (inClass) continue;
            inClass = true;
            start = i;
        }
        if (inClass && len - start == wantLen) {
            return classAttr.regionMatches(true, start, className, 0, wantLen);
        }
        return false;
    }

    public Element addClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.add(className);
        this.classNames(classes);
        return this;
    }

    public Element removeClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.remove(className);
        this.classNames(classes);
        return this;
    }

    public Element toggleClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        if (classes.contains(className)) {
            classes.remove(className);
        } else {
            classes.add(className);
        }
        this.classNames(classes);
        return this;
    }

    public String val() {
        if (this.tagName().equals("textarea")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String value2) {
        if (this.tagName().equals("textarea")) {
            this.text(value2);
        } else {
            this.attr("value", value2);
        }
        return this;
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (out.prettyPrint() && (this.tag.formatAsBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || out.outline())) {
            if (accum instanceof StringBuilder) {
                if (((StringBuilder)accum).length() > 0) {
                    this.indent(accum, depth, out);
                }
            } else {
                this.indent(accum, depth, out);
            }
        }
        accum.append("<").append(this.tagName());
        this.attributes.html(accum, out);
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            if (out.syntax() == Document.OutputSettings.Syntax.html && this.tag.isEmpty()) {
                accum.append('>');
            } else {
                accum.append(" />");
            }
        } else {
            accum.append(">");
        }
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            if (out.prettyPrint() && !this.childNodes.isEmpty() && (this.tag.formatAsBlock() || out.outline() && (this.childNodes.size() > 1 || this.childNodes.size() == 1 && !(this.childNodes.get(0) instanceof TextNode)))) {
                this.indent(accum, depth, out);
            }
            accum.append("</").append(this.tagName()).append(">");
        }
    }

    public String html() {
        StringBuilder accum = new StringBuilder();
        this.html(accum);
        return this.getOutputSettings().prettyPrint() ? accum.toString().trim() : accum.toString();
    }

    private void html(StringBuilder accum) {
        for (Node node4 : this.childNodes) {
            node4.outerHtml(accum);
        }
    }

    @Override
    public <T extends Appendable> T html(T appendable) {
        for (Node node4 : this.childNodes) {
            node4.outerHtml(appendable);
        }
        return appendable;
    }

    public Element html(String html) {
        this.empty();
        this.append(html);
        return this;
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }
}

