/*
 * Decompiled with CFR 0.152.
 */
package ensime.shaded.io.github.soc.directories;

import ensime.shaded.io.github.soc.directories.UnsupportedOperatingSystemException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;

final class Util {
    static final String operatingSystemName = System.getProperty("os.name");
    static final char operatingSystem;
    static final char LIN = 'l';
    static final char MAC = 'm';
    static final char WIN = 'w';
    static final char BSD = 'b';

    private Util() {
        throw new Error();
    }

    static void requireNonNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static String defaultIfNullOrEmpty(String string2, String string3, String string4) {
        Util.requireNonNull(string4);
        if (string2 == null || string2.isEmpty()) {
            return string3 + string4;
        }
        return string2;
    }

    static String defaultIfNullOrEmptyExtended(String string2, String string3, String string4, String string5) {
        Util.requireNonNull(string3);
        Util.requireNonNull(string4);
        Util.requireNonNull(string5);
        if (string2 == null || string2.isEmpty()) {
            return string4 + string5;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String runXDGUserDir(String string2) {
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder("xdg-user-dir", string2);
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String string3 = bufferedReader.readLine();
            return string3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string4 = null;
            return string4;
        }
        finally {
            process.destroy();
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String runPowerShellCommand(String string2) {
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder("powershell.exe", "-Command", "[Environment]::GetFolderPath([Environment+SpecialFolder]::" + string2 + ")");
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String string3 = bufferedReader.readLine();
            return string3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string4 = null;
            return string4;
        }
        finally {
            process.destroy();
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    static String stripQualification(String string2) {
        int n = string2.lastIndexOf(46) + 1;
        return string2.substring(n);
    }

    static String trimAndReplaceSpacesWithHyphensThenLowerCase(String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        boolean bl = false;
        int n = string2.codePointCount(0, string2.length());
        for (int i = 0; i < n; ++i) {
            int n2 = string2.codePointAt(i);
            if (n2 == 32) {
                if (!bl || !Util.codePointExistsAndNotSpace(string2, n, i + 1)) continue;
                stringBuilder.append('-');
                bl = false;
                continue;
            }
            stringBuilder.appendCodePoint(Character.toLowerCase(n2));
            bl = true;
        }
        return stringBuilder.toString();
    }

    private static boolean codePointExistsAndNotSpace(String string2, int n, int n2) {
        return n2 < n && string2.codePointAt(n2) != 32;
    }

    static {
        String string2 = operatingSystemName.toLowerCase(Locale.ENGLISH);
        if (string2.contains("linux")) {
            operatingSystem = (char)108;
        } else if (string2.contains("mac")) {
            operatingSystem = (char)109;
        } else if (string2.contains("windows")) {
            operatingSystem = (char)119;
        } else if (string2.contains("bsd")) {
            operatingSystem = (char)98;
        } else {
            throw new UnsupportedOperatingSystemException("Base directories are not supported on " + operatingSystemName);
        }
    }
}

