/*
 * Decompiled with CFR 0.152.
 */
package ensime.shaded.coursier.shaded.org.jsoup.select;

import ensime.shaded.coursier.shaded.org.jsoup.helper.Validate;
import ensime.shaded.coursier.shaded.org.jsoup.internal.Normalizer;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Comment;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Document;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.DocumentType;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Element;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Node;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.XmlDeclaration;
import ensime.shaded.coursier.shaded.org.jsoup.select.Elements;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Evaluator {
    protected Evaluator() {
    }

    public abstract boolean matches(Element var1, Element var2);

    public static final class MatchesOwn
    extends Evaluator {
        private Pattern pattern;

        public MatchesOwn(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(Element root, Element element2) {
            Matcher m = this.pattern.matcher(element2.ownText());
            return m.find();
        }

        public String toString() {
            return String.format(":matchesOwn(%s)", this.pattern);
        }
    }

    public static final class Matches
    extends Evaluator {
        private Pattern pattern;

        public Matches(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(Element root, Element element2) {
            Matcher m = this.pattern.matcher(element2.text());
            return m.find();
        }

        public String toString() {
            return String.format(":matches(%s)", this.pattern);
        }
    }

    public static final class ContainsOwnText
    extends Evaluator {
        private String searchText;

        public ContainsOwnText(String searchText) {
            this.searchText = Normalizer.lowerCase(searchText);
        }

        public boolean matches(Element root, Element element2) {
            return Normalizer.lowerCase(element2.ownText()).contains(this.searchText);
        }

        public String toString() {
            return String.format(":containsOwn(%s)", this.searchText);
        }
    }

    public static final class ContainsData
    extends Evaluator {
        private String searchText;

        public ContainsData(String searchText) {
            this.searchText = Normalizer.lowerCase(searchText);
        }

        public boolean matches(Element root, Element element2) {
            return Normalizer.lowerCase(element2.data()).contains(this.searchText);
        }

        public String toString() {
            return String.format(":containsData(%s)", this.searchText);
        }
    }

    public static final class ContainsText
    extends Evaluator {
        private String searchText;

        public ContainsText(String searchText) {
            this.searchText = Normalizer.lowerCase(searchText);
        }

        public boolean matches(Element root, Element element2) {
            return Normalizer.lowerCase(element2.text()).contains(this.searchText);
        }

        public String toString() {
            return String.format(":contains(%s)", this.searchText);
        }
    }

    public static abstract class IndexEvaluator
    extends Evaluator {
        int index;

        public IndexEvaluator(int index2) {
            this.index = index2;
        }
    }

    public static final class IsEmpty
    extends Evaluator {
        public boolean matches(Element root, Element element2) {
            List<Node> family = element2.childNodes();
            for (Node n : family) {
                if (n instanceof Comment || n instanceof XmlDeclaration || n instanceof DocumentType) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return ":empty";
        }
    }

    public static final class IsOnlyOfType
    extends Evaluator {
        public boolean matches(Element root, Element element2) {
            Element p = element2.parent();
            if (p == null || p instanceof Document) {
                return false;
            }
            int pos = 0;
            Elements family = p.children();
            for (Element el : family) {
                if (!el.tag().equals(element2.tag())) continue;
                ++pos;
            }
            return pos == 1;
        }

        public String toString() {
            return ":only-of-type";
        }
    }

    public static final class IsOnlyChild
    extends Evaluator {
        public boolean matches(Element root, Element element2) {
            Element p = element2.parent();
            return p != null && !(p instanceof Document) && element2.siblingElements().size() == 0;
        }

        public String toString() {
            return ":only-child";
        }
    }

    public static final class IsRoot
    extends Evaluator {
        public boolean matches(Element root, Element element2) {
            Element r = root instanceof Document ? root.child(0) : root;
            return element2 == r;
        }

        public String toString() {
            return ":root";
        }
    }

    public static final class IsFirstChild
    extends Evaluator {
        public boolean matches(Element root, Element element2) {
            Element p = element2.parent();
            return p != null && !(p instanceof Document) && element2.elementSiblingIndex() == 0;
        }

        public String toString() {
            return ":first-child";
        }
    }

    public static class IsNthLastOfType
    extends CssNthEvaluator {
        public IsNthLastOfType(int a2, int b2) {
            super(a2, b2);
        }

        protected int calculatePosition(Element root, Element element2) {
            int pos = 0;
            Elements family = element2.parent().children();
            for (int i = element2.elementSiblingIndex(); i < family.size(); ++i) {
                if (!((Element)family.get(i)).tag().equals(element2.tag())) continue;
                ++pos;
            }
            return pos;
        }

        protected String getPseudoClass() {
            return "nth-last-of-type";
        }
    }

    public static class IsNthOfType
    extends CssNthEvaluator {
        public IsNthOfType(int a2, int b2) {
            super(a2, b2);
        }

        protected int calculatePosition(Element root, Element element2) {
            int pos = 0;
            Elements family = element2.parent().children();
            for (Element el : family) {
                if (el.tag().equals(element2.tag())) {
                    ++pos;
                }
                if (el != element2) continue;
                break;
            }
            return pos;
        }

        protected String getPseudoClass() {
            return "nth-of-type";
        }
    }

    public static final class IsNthLastChild
    extends CssNthEvaluator {
        public IsNthLastChild(int a2, int b2) {
            super(a2, b2);
        }

        protected int calculatePosition(Element root, Element element2) {
            return element2.parent().children().size() - element2.elementSiblingIndex();
        }

        protected String getPseudoClass() {
            return "nth-last-child";
        }
    }

    public static final class IsNthChild
    extends CssNthEvaluator {
        public IsNthChild(int a2, int b2) {
            super(a2, b2);
        }

        protected int calculatePosition(Element root, Element element2) {
            return element2.elementSiblingIndex() + 1;
        }

        protected String getPseudoClass() {
            return "nth-child";
        }
    }

    public static abstract class CssNthEvaluator
    extends Evaluator {
        protected final int a;
        protected final int b;

        public CssNthEvaluator(int a2, int b2) {
            this.a = a2;
            this.b = b2;
        }

        public CssNthEvaluator(int b2) {
            this(0, b2);
        }

        public boolean matches(Element root, Element element2) {
            Element p = element2.parent();
            if (p == null || p instanceof Document) {
                return false;
            }
            int pos = this.calculatePosition(root, element2);
            if (this.a == 0) {
                return pos == this.b;
            }
            return (pos - this.b) * this.a >= 0 && (pos - this.b) % this.a == 0;
        }

        public String toString() {
            if (this.a == 0) {
                return String.format(":%s(%d)", this.getPseudoClass(), this.b);
            }
            if (this.b == 0) {
                return String.format(":%s(%dn)", this.getPseudoClass(), this.a);
            }
            return String.format(":%s(%dn%+d)", this.getPseudoClass(), this.a, this.b);
        }

        protected abstract String getPseudoClass();

        protected abstract int calculatePosition(Element var1, Element var2);
    }

    public static final class IsLastOfType
    extends IsNthLastOfType {
        public IsLastOfType() {
            super(0, 1);
        }

        public String toString() {
            return ":last-of-type";
        }
    }

    public static final class IsFirstOfType
    extends IsNthOfType {
        public IsFirstOfType() {
            super(0, 1);
        }

        public String toString() {
            return ":first-of-type";
        }
    }

    public static final class IsLastChild
    extends Evaluator {
        public boolean matches(Element root, Element element2) {
            Element p = element2.parent();
            return p != null && !(p instanceof Document) && element2.elementSiblingIndex() == p.children().size() - 1;
        }

        public String toString() {
            return ":last-child";
        }
    }

    public static final class IndexEquals
    extends IndexEvaluator {
        public IndexEquals(int index2) {
            super(index2);
        }

        public boolean matches(Element root, Element element2) {
            return element2.elementSiblingIndex() == this.index;
        }

        public String toString() {
            return String.format(":eq(%d)", this.index);
        }
    }

    public static final class IndexGreaterThan
    extends IndexEvaluator {
        public IndexGreaterThan(int index2) {
            super(index2);
        }

        public boolean matches(Element root, Element element2) {
            return element2.elementSiblingIndex() > this.index;
        }

        public String toString() {
            return String.format(":gt(%d)", this.index);
        }
    }

    public static final class IndexLessThan
    extends IndexEvaluator {
        public IndexLessThan(int index2) {
            super(index2);
        }

        public boolean matches(Element root, Element element2) {
            return element2.elementSiblingIndex() < this.index;
        }

        public String toString() {
            return String.format(":lt(%d)", this.index);
        }
    }

    public static final class AllElements
    extends Evaluator {
        public boolean matches(Element root, Element element2) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }

    public static abstract class AttributeKeyPair
    extends Evaluator {
        String key;
        String value;

        public AttributeKeyPair(String key, String value2) {
            Validate.notEmpty(key);
            Validate.notEmpty(value2);
            this.key = Normalizer.normalize(key);
            if (value2.startsWith("\"") && value2.endsWith("\"") || value2.startsWith("'") && value2.endsWith("'")) {
                value2 = value2.substring(1, value2.length() - 1);
            }
            this.value = Normalizer.normalize(value2);
        }
    }

    public static final class AttributeWithValueMatching
    extends Evaluator {
        String key;
        Pattern pattern;

        public AttributeWithValueMatching(String key, Pattern pattern) {
            this.key = Normalizer.normalize(key);
            this.pattern = pattern;
        }

        public boolean matches(Element root, Element element2) {
            return element2.hasAttr(this.key) && this.pattern.matcher(element2.attr(this.key)).find();
        }

        public String toString() {
            return String.format("[%s~=%s]", this.key, this.pattern.toString());
        }
    }

    public static final class AttributeWithValueContaining
    extends AttributeKeyPair {
        public AttributeWithValueContaining(String key, String value2) {
            super(key, value2);
        }

        public boolean matches(Element root, Element element2) {
            return element2.hasAttr(this.key) && Normalizer.lowerCase(element2.attr(this.key)).contains(this.value);
        }

        public String toString() {
            return String.format("[%s*=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueEnding
    extends AttributeKeyPair {
        public AttributeWithValueEnding(String key, String value2) {
            super(key, value2);
        }

        public boolean matches(Element root, Element element2) {
            return element2.hasAttr(this.key) && Normalizer.lowerCase(element2.attr(this.key)).endsWith(this.value);
        }

        public String toString() {
            return String.format("[%s$=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueStarting
    extends AttributeKeyPair {
        public AttributeWithValueStarting(String key, String value2) {
            super(key, value2);
        }

        public boolean matches(Element root, Element element2) {
            return element2.hasAttr(this.key) && Normalizer.lowerCase(element2.attr(this.key)).startsWith(this.value);
        }

        public String toString() {
            return String.format("[%s^=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueNot
    extends AttributeKeyPair {
        public AttributeWithValueNot(String key, String value2) {
            super(key, value2);
        }

        public boolean matches(Element root, Element element2) {
            return !this.value.equalsIgnoreCase(element2.attr(this.key));
        }

        public String toString() {
            return String.format("[%s!=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValue
    extends AttributeKeyPair {
        public AttributeWithValue(String key, String value2) {
            super(key, value2);
        }

        public boolean matches(Element root, Element element2) {
            return element2.hasAttr(this.key) && this.value.equalsIgnoreCase(element2.attr(this.key).trim());
        }

        public String toString() {
            return String.format("[%s=%s]", this.key, this.value);
        }
    }

    public static final class AttributeStarting
    extends Evaluator {
        private String keyPrefix;

        public AttributeStarting(String keyPrefix) {
            Validate.notEmpty(keyPrefix);
            this.keyPrefix = Normalizer.lowerCase(keyPrefix);
        }

        public boolean matches(Element root, Element element2) {
            List<ensime.shaded.coursier.shaded.org.jsoup.nodes.Attribute> values2 = element2.attributes().asList();
            for (ensime.shaded.coursier.shaded.org.jsoup.nodes.Attribute attribute : values2) {
                if (!Normalizer.lowerCase(attribute.getKey()).startsWith(this.keyPrefix)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format("[^%s]", this.keyPrefix);
        }
    }

    public static final class Attribute
    extends Evaluator {
        private String key;

        public Attribute(String key) {
            this.key = key;
        }

        public boolean matches(Element root, Element element2) {
            return element2.hasAttr(this.key);
        }

        public String toString() {
            return String.format("[%s]", this.key);
        }
    }

    public static final class Class
    extends Evaluator {
        private String className;

        public Class(String className) {
            this.className = className;
        }

        public boolean matches(Element root, Element element2) {
            return element2.hasClass(this.className);
        }

        public String toString() {
            return String.format(".%s", this.className);
        }
    }

    public static final class Id
    extends Evaluator {
        private String id;

        public Id(String id2) {
            this.id = id2;
        }

        public boolean matches(Element root, Element element2) {
            return this.id.equals(element2.id());
        }

        public String toString() {
            return String.format("#%s", this.id);
        }
    }

    public static final class TagEndsWith
    extends Evaluator {
        private String tagName;

        public TagEndsWith(String tagName) {
            this.tagName = tagName;
        }

        public boolean matches(Element root, Element element2) {
            return element2.tagName().endsWith(this.tagName);
        }

        public String toString() {
            return String.format("%s", this.tagName);
        }
    }

    public static final class Tag
    extends Evaluator {
        private String tagName;

        public Tag(String tagName) {
            this.tagName = tagName;
        }

        public boolean matches(Element root, Element element2) {
            return element2.tagName().equalsIgnoreCase(this.tagName);
        }

        public String toString() {
            return String.format("%s", this.tagName);
        }
    }
}

