/*
 * Decompiled with CFR 0.152.
 */
package ensime.shaded.io.github.soc.directories;

import ensime.shaded.io.github.soc.directories.UnsupportedOperatingSystemException;
import ensime.shaded.io.github.soc.directories.Util;
import java.util.Locale;

public final class ProjectDirectories {
    public final String projectName;
    public final String projectCacheDir;
    public final String projectConfigDir;
    public final String projectDataDir;
    public final String projectDataRoamingDir;

    private ProjectDirectories(String string2, String string3, String string4, String string5, String string6) {
        Util.requireNonNull(string2);
        this.projectName = string2;
        this.projectCacheDir = string3;
        this.projectConfigDir = string4;
        this.projectDataDir = string5;
        this.projectDataRoamingDir = string6;
    }

    public static ProjectDirectories fromUnprocessedString(String string2) {
        String string3;
        String string4;
        String string5;
        String string6;
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': {
                String string7 = System.getenv("HOME");
                string6 = Util.defaultIfNullOrEmpty(System.getenv("XDG_CACHE_HOME"), string7 + "/.cache/", string2 + "/");
                string5 = Util.defaultIfNullOrEmpty(System.getenv("XDG_CONFIG_HOME"), string7 + "/.config/", string2 + "/");
                string3 = string4 = Util.defaultIfNullOrEmpty(System.getenv("XDG_DATA_HOME"), string7 + "/.local/share/", string2 + "/");
                break;
            }
            case 'm': {
                String string8 = System.getenv("HOME");
                string6 = string8 + "/Library/Caches/" + string2 + "/";
                string5 = string8 + "/Library/Preferences/" + string2 + "/";
                string3 = string4 = string8 + "/Library/Application Support/" + string2 + "/";
                break;
            }
            case 'w': {
                string4 = Util.runPowerShellCommand("LocalApplicationData") + "/" + string2 + "/";
                string3 = Util.runPowerShellCommand("ApplicationData") + "/" + string2 + "/";
                string5 = string4;
                string6 = string4 + "cache/";
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Util.operatingSystemName);
            }
        }
        return new ProjectDirectories(string2, string6, string5, string4, string3);
    }

    public static ProjectDirectories fromQualifiedProjectName(String string2) {
        String string3;
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': {
                string3 = Util.stripQualification(string2).toLowerCase(Locale.ENGLISH).trim();
                break;
            }
            case 'm': {
                string3 = string2;
                break;
            }
            case 'w': {
                string3 = Util.stripQualification(string2);
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Util.operatingSystemName);
            }
        }
        return ProjectDirectories.fromUnprocessedString(string3);
    }

    public static ProjectDirectories fromProjectName(String string2) {
        String string3;
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': {
                string3 = Util.trimAndReplaceSpacesWithHyphensThenLowerCase(string2);
                break;
            }
            case 'm': 
            case 'w': {
                string3 = string2;
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Util.operatingSystemName);
            }
        }
        return ProjectDirectories.fromUnprocessedString(string3);
    }

    public String toString() {
        return "ProjectDirectories on operating system '" + Util.operatingSystemName + "':  projectName           ='" + this.projectName + '\'' + "  projectCacheDir       ='" + this.projectCacheDir + '\'' + "  projectConfigDir      ='" + this.projectConfigDir + '\'' + "  projectDataDir        ='" + this.projectDataDir + '\'' + "  projectDataRoamingDir ='" + this.projectDataRoamingDir + '\'';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProjectDirectories projectDirectories = (ProjectDirectories)object;
        if (!this.projectName.equals(projectDirectories.projectName)) {
            return false;
        }
        if (this.projectCacheDir != null ? !this.projectCacheDir.equals(projectDirectories.projectCacheDir) : projectDirectories.projectCacheDir != null) {
            return false;
        }
        if (this.projectConfigDir != null ? !this.projectConfigDir.equals(projectDirectories.projectConfigDir) : projectDirectories.projectConfigDir != null) {
            return false;
        }
        if (this.projectDataDir != null ? !this.projectDataDir.equals(projectDirectories.projectDataDir) : projectDirectories.projectDataDir != null) {
            return false;
        }
        return this.projectDataRoamingDir != null ? this.projectDataRoamingDir.equals(projectDirectories.projectDataRoamingDir) : projectDirectories.projectDataRoamingDir == null;
    }

    public int hashCode() {
        int n = this.projectName.hashCode();
        n = 31 * n + (this.projectCacheDir != null ? this.projectCacheDir.hashCode() : 0);
        n = 31 * n + (this.projectConfigDir != null ? this.projectConfigDir.hashCode() : 0);
        n = 31 * n + (this.projectDataDir != null ? this.projectDataDir.hashCode() : 0);
        n = 31 * n + (this.projectDataRoamingDir != null ? this.projectDataRoamingDir.hashCode() : 0);
        return n;
    }
}

