/*
 * Decompiled with CFR 0.152.
 */
package ensime.shaded.coursier.shaded.org.jsoup.select;

import ensime.shaded.coursier.shaded.org.jsoup.nodes.Element;
import ensime.shaded.coursier.shaded.org.jsoup.select.Evaluator;

abstract class StructuralEvaluator
extends Evaluator {
    Evaluator evaluator;

    StructuralEvaluator() {
    }

    static class ImmediatePreviousSibling
    extends StructuralEvaluator {
        public ImmediatePreviousSibling(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean matches(Element root, Element element2) {
            if (root == element2) {
                return false;
            }
            Element prev = element2.previousElementSibling();
            return prev != null && this.evaluator.matches(root, prev);
        }

        public String toString() {
            return String.format(":prev%s", this.evaluator);
        }
    }

    static class PreviousSibling
    extends StructuralEvaluator {
        public PreviousSibling(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean matches(Element root, Element element2) {
            if (root == element2) {
                return false;
            }
            for (Element prev = element2.previousElementSibling(); prev != null; prev = prev.previousElementSibling()) {
                if (!this.evaluator.matches(root, prev)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format(":prev*%s", this.evaluator);
        }
    }

    static class ImmediateParent
    extends StructuralEvaluator {
        public ImmediateParent(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean matches(Element root, Element element2) {
            if (root == element2) {
                return false;
            }
            Element parent2 = element2.parent();
            return parent2 != null && this.evaluator.matches(root, parent2);
        }

        public String toString() {
            return String.format(":ImmediateParent%s", this.evaluator);
        }
    }

    static class Parent
    extends StructuralEvaluator {
        public Parent(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean matches(Element root, Element element2) {
            if (root == element2) {
                return false;
            }
            Element parent2 = element2.parent();
            while (true) {
                if (this.evaluator.matches(root, parent2)) {
                    return true;
                }
                if (parent2 == root) break;
                parent2 = parent2.parent();
            }
            return false;
        }

        public String toString() {
            return String.format(":parent%s", this.evaluator);
        }
    }

    static class Not
    extends StructuralEvaluator {
        public Not(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean matches(Element root, Element node4) {
            return !this.evaluator.matches(root, node4);
        }

        public String toString() {
            return String.format(":not%s", this.evaluator);
        }
    }

    static class Has
    extends StructuralEvaluator {
        public Has(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean matches(Element root, Element element2) {
            for (Element e : element2.getAllElements()) {
                if (e == element2 || !this.evaluator.matches(root, e)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format(":has(%s)", this.evaluator);
        }
    }

    static class Root
    extends Evaluator {
        Root() {
        }

        public boolean matches(Element root, Element element2) {
            return root == element2;
        }
    }
}

