/*
 * Decompiled with CFR 0.152.
 */
package ensime.shaded.coursier.shaded.org.jsoup.parser;

import ensime.shaded.coursier.shaded.org.jsoup.nodes.Document;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Element;
import ensime.shaded.coursier.shaded.org.jsoup.nodes.Node;
import ensime.shaded.coursier.shaded.org.jsoup.parser.CharacterReader;
import ensime.shaded.coursier.shaded.org.jsoup.parser.HtmlTreeBuilder;
import ensime.shaded.coursier.shaded.org.jsoup.parser.ParseError;
import ensime.shaded.coursier.shaded.org.jsoup.parser.ParseErrorList;
import ensime.shaded.coursier.shaded.org.jsoup.parser.ParseSettings;
import ensime.shaded.coursier.shaded.org.jsoup.parser.Tokeniser;
import ensime.shaded.coursier.shaded.org.jsoup.parser.TreeBuilder;
import ensime.shaded.coursier.shaded.org.jsoup.parser.XmlTreeBuilder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final int DEFAULT_MAX_ERRORS = 0;
    private TreeBuilder treeBuilder;
    private int maxErrors = 0;
    private ParseErrorList errors;
    private ParseSettings settings;

    public Parser(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        this.settings = treeBuilder.defaultSettings();
    }

    public Document parseInput(String html, String baseUri) {
        this.errors = this.isTrackErrors() ? ParseErrorList.tracking(this.maxErrors) : ParseErrorList.noTracking();
        return this.treeBuilder.parse(html, baseUri, this.errors, this.settings);
    }

    public TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public Parser setTreeBuilder(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        return this;
    }

    public boolean isTrackErrors() {
        return this.maxErrors > 0;
    }

    public Parser setTrackErrors(int maxErrors) {
        this.maxErrors = maxErrors;
        return this;
    }

    public List<ParseError> getErrors() {
        return this.errors;
    }

    public Parser settings(ParseSettings settings) {
        this.settings = settings;
        return this;
    }

    public ParseSettings settings() {
        return this.settings;
    }

    public static Document parse(String html, String baseUri) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return ((TreeBuilder)treeBuilder).parse(html, baseUri, ParseErrorList.noTracking(), ((TreeBuilder)treeBuilder).defaultSettings());
    }

    public static List<Node> parseFragment(String fragmentHtml, Element context, String baseUri) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return treeBuilder.parseFragment(fragmentHtml, context, baseUri, ParseErrorList.noTracking(), treeBuilder.defaultSettings());
    }

    public static List<Node> parseFragment(String fragmentHtml, Element context, String baseUri, ParseErrorList errorList) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return treeBuilder.parseFragment(fragmentHtml, context, baseUri, errorList, treeBuilder.defaultSettings());
    }

    public static List<Node> parseXmlFragment(String fragmentXml, String baseUri) {
        XmlTreeBuilder treeBuilder = new XmlTreeBuilder();
        return treeBuilder.parseFragment(fragmentXml, baseUri, ParseErrorList.noTracking(), treeBuilder.defaultSettings());
    }

    public static Document parseBodyFragment(String bodyHtml, String baseUri) {
        Document doc = Document.createShell(baseUri);
        Element body = doc.body();
        List<Node> nodeList = Parser.parseFragment(bodyHtml, body, baseUri);
        Node[] nodes = nodeList.toArray(new Node[nodeList.size()]);
        for (int i = nodes.length - 1; i > 0; --i) {
            nodes[i].remove();
        }
        for (Node node : nodes) {
            body.appendChild(node);
        }
        return doc;
    }

    public static String unescapeEntities(String string2, boolean inAttribute) {
        Tokeniser tokeniser = new Tokeniser(new CharacterReader(string2), ParseErrorList.noTracking());
        return tokeniser.unescapeEntities(inAttribute);
    }

    public static Document parseBodyFragmentRelaxed(String bodyHtml, String baseUri) {
        return Parser.parse(bodyHtml, baseUri);
    }

    public static Parser htmlParser() {
        return new Parser(new HtmlTreeBuilder());
    }

    public static Parser xmlParser() {
        return new Parser(new XmlTreeBuilder());
    }
}

