/*
 * Decompiled with CFR 0.152.
 */
package org.ensime.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import org.ensime.api.RpcRequestEnvelope;
import org.ensime.api.RpcResponseEnvelope;
import org.ensime.core.DocJarReading;
import org.ensime.server.DocsHandler;
import org.ensime.server.WebServer$;
import org.ensime.server.WebSocketFrameHandler;
import scala.Function1;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;

public final class WebServer$ {
    public static final WebServer$ MODULE$;

    static {
        new WebServer$();
    }

    public void initPipeline(ChannelPipeline pipeline, DocJarReading docs, Function1<Function1<RpcResponseEnvelope, BoxedUnit>, Function1<RpcRequestEnvelope, BoxedUnit>> hookHandlers) {
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/websocket", "jerky, swanky")});
        pipeline.addLast(new ChannelHandler[]{new WebSocketFrameHandler(hookHandlers)});
        pipeline.addLast(new ChannelHandler[]{new DocsHandler(docs)});
    }

    public Future<Channel> start(DocJarReading docs, int port, Function1<Function1<RpcResponseEnvelope, BoxedUnit>, Function1<RpcRequestEnvelope, BoxedUnit>> hookHandlers) {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        ChannelInitializer<SocketChannel> channelInitializer = new ChannelInitializer<SocketChannel>(docs, hookHandlers){
            private final DocJarReading docs$1;
            private final Function1 hookHandlers$1;

            public void initChannel(SocketChannel ch) {
                WebServer$.MODULE$.initPipeline(ch.pipeline(), this.docs$1, (Function1<Function1<RpcResponseEnvelope, BoxedUnit>, Function1<RpcRequestEnvelope, BoxedUnit>>)this.hookHandlers$1);
            }
            {
                this.docs$1 = docs$1;
                this.hookHandlers$1 = hookHandlers$1;
            }
        };
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class).handler((ChannelHandler)new LoggingHandler())).childHandler((ChannelHandler)channelInitializer);
        Promise p = Promise$.MODULE$.apply();
        b.bind("127.0.0.1", port).addListener((GenericFutureListener)new ChannelFutureListener((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup, p){
            public final EventLoopGroup bossGroup$1;
            public final EventLoopGroup workerGroup$1;
            private final Promise p$1;

            public void operationComplete(ChannelFuture ftr) {
                if (ftr.isSuccess()) {
                    Channel ch = ftr.channel();
                    ch.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(this){
                        private final /* synthetic */ anon.2 $outer;

                        public void operationComplete(ChannelFuture ftr2) {
                            this.$outer.bossGroup$1.shutdownGracefully();
                            this.$outer.workerGroup$1.shutdownGracefully();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.p$1.success((Object)ch);
                } else {
                    this.p$1.failure(ftr.cause());
                    this.bossGroup$1.shutdownGracefully();
                    this.workerGroup$1.shutdownGracefully();
                }
            }
            {
                this.bossGroup$1 = bossGroup$1;
                this.workerGroup$1 = workerGroup$1;
                this.p$1 = p$1;
            }
        });
        return p.future();
    }

    private WebServer$() {
        MODULE$ = this;
    }
}

