/*
 * Decompiled with CFR 0.152.
 */
package org.ensime.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.util.AttributeKey;
import org.ensime.api.EnsimeServerError;
import org.ensime.api.EnsimeServerMessage;
import org.ensime.api.RpcRequestEnvelope;
import org.ensime.api.RpcResponseEnvelope;
import org.ensime.server.JerkySubprotocolEncoder$;
import org.ensime.server.SubprotocolEncoder;
import org.ensime.server.SwankySubprotocolEncoder$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u0001%\u0011QcV3c'>\u001c7.\u001a;Ge\u0006lW\rS1oI2,'O\u0003\u0002\u0004\t\u000511/\u001a:wKJT!!\u0002\u0004\u0002\r\u0015t7/[7f\u0015\u00059\u0011aA8sO\u000e\u00011C\u0001\u0001\u000b!\rY!\u0003F\u0007\u0002\u0019)\u0011QBD\u0001\bG\"\fgN\\3m\u0015\ty\u0001#A\u0003oKR$\u0018PC\u0001\u0012\u0003\tIw.\u0003\u0002\u0014\u0019\tY2+[7qY\u0016\u001c\u0005.\u00198oK2LeNY8v]\u0012D\u0015M\u001c3mKJ\u0004\"!\u0006\u0010\u000e\u0003YQ!a\u0006\r\u0002\u0015],'m]8dW\u0016$\bP\u0003\u0002\u001a5\u0005!\u0001\u000e\u001e;q\u0015\tYB$A\u0003d_\u0012,7M\u0003\u0002\u001e\u001d\u00059\u0001.\u00198eY\u0016\u0014\u0018BA\u0010\u0017\u000599VMY*pG.,GO\u0012:b[\u0016D\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\rQ>|7\u000eS1oI2,'o\u001d\t\u0003G=r!\u0001J\u0017\u000f\u0005\u0015bcB\u0001\u0014,\u001d\t9#&D\u0001)\u0015\tI\u0003\"\u0001\u0004=e>|GOP\u0005\u0002\u000f%\u0011QAB\u0005\u0003\u0007\u0011I!A\f\u0002\u0002\u0013]+'mU3sm\u0016\u0014\u0018B\u0001\u00192\u00051Aun\\6IC:$G.\u001a:t\u0015\tq#\u0001C\u00034\u0001\u0011\u0005A'\u0001\u0004=S:LGO\u0010\u000b\u0003k]\u0002\"A\u000e\u0001\u000e\u0003\tAQ!\t\u001aA\u0002\tBq!\u000f\u0001C\u0002\u0013\u0005!(A\u0002m_\u001e,\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0003}\u0019\tQa\u001d7gi)L!\u0001Q\u001f\u0003\r1{wmZ3s\u0011\u0019\u0011\u0005\u0001)A\u0005w\u0005!An\\4!\u0011\u001d!\u0005A1A\u0005\u0002\u0015\u000bA\"\u001b8IC:$G.\u001a:LKf,\u0012A\u0012\t\u0004\u000f*cU\"\u0001%\u000b\u0005%s\u0011\u0001B;uS2L!a\u0013%\u0003\u0019\u0005#HO]5ckR,7*Z=\u0011\t5\u0003&+W\u0007\u0002\u001d*\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\nIa)\u001e8di&|g.\r\t\u0003'Zs!!\u0014+\n\u0005Us\u0015A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!\u0016(\u0011\u00055S\u0016BA.O\u0005\u0011)f.\u001b;\t\ru\u0003\u0001\u0015!\u0003G\u00035Ig\u000eS1oI2,'oS3zA!9q\f\u0001b\u0001\n\u0003\u0001\u0017!D8vi\"\u000bg\u000e\u001a7fe.+\u00170F\u0001b!\r9%J\u0019\t\u0003G\rL!\u0001Z\u0019\u0003\u001f=+HoZ8j]\u001eD\u0015M\u001c3mKJDaA\u001a\u0001!\u0002\u0013\t\u0017AD8vi\"\u000bg\u000e\u001a7fe.+\u0017\u0010\t\u0005\u0006Q\u0002!I![\u0001\rg\u0016$\u0018J\u001c%b]\u0012dWM\u001d\u000b\u00043*|\u0007\"B6h\u0001\u0004a\u0017aA2uqB\u00111\"\\\u0005\u0003]2\u0011Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0003qO\u0002\u0007A*A\u0005j]\"\u000bg\u000e\u001a7fe\")!\u000f\u0001C\u0005g\u0006aq-\u001a;J]\"\u000bg\u000e\u001a7feR\u0011A\n\u001e\u0005\u0006WF\u0004\r\u0001\u001c\u0005\u0006m\u0002!Ia^\u0001\u000eg\u0016$x*\u001e;IC:$G.\u001a:\u0015\u0007eC\u0018\u0010C\u0003lk\u0002\u0007A\u000eC\u0003{k\u0002\u0007!-\u0001\u0006pkRD\u0015M\u001c3mKJDQ\u0001 \u0001\u0005\nu\fQbZ3u\u001fV$\b*\u00198eY\u0016\u0014HC\u00012\u007f\u0011\u0015Y7\u00101\u0001m\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007\t!\"\u001a8d_\u0012,'OR8s)\u0011\t)!a\u0003\u0011\u0007Y\n9!C\u0002\u0002\n\t\u0011!cU;caJ|Go\\2pY\u0016s7m\u001c3fe\"1\u0011QB@A\u0002I\u000b1b];caJ|Go\\2pY\"9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0011!E3oG>$W\rZ(vi\"\u000bg\u000e\u001a7feR)!-!\u0006\u0002 !A\u0011qCA\b\u0001\u0004\tI\"\u0001\u0002dQB\u00191\"a\u0007\n\u0007\u0005uABA\u0004DQ\u0006tg.\u001a7\t\u0011\u0005\u0005\u0012q\u0002a\u0001\u0003\u000b\tq!\u001a8d_\u0012,'\u000fC\u0004\u0002&\u0001!I!a\n\u0002!\u0015t7m\u001c3fI&s\u0007*\u00198eY\u0016\u0014H#\u0002'\u0002*\u0005E\u0002b\u00029\u0002$\u0001\u0007\u00111\u0006\t\u0004G\u00055\u0012bAA\u0018c\ty\u0011J\\2p[&tw\rS1oI2,'\u000f\u0003\u0005\u0002\"\u0005\r\u0002\u0019AA\u0003\u0011\u001d\t)\u0004\u0001C)\u0003o\t!#^:fe\u00163XM\u001c;Ue&<w-\u001a:fIR)\u0011,!\u000f\u0002<!11.a\rA\u00021D\u0001\"!\u0010\u00024\u0001\u0007\u0011qH\u0001\u0004KZ$\b\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005Y\u0006twM\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%a\u0011\u0003\r=\u0013'.Z2u\u0011\u001d\t\t\u0006\u0001C)\u0003'\nAb\u00195b]:,GNU3bIB\"R!WA+\u0003/Baa[A(\u0001\u0004a\u0007bBA-\u0003\u001f\u0002\r\u0001F\u0001\u0006MJ\fW.\u001a\u0005\b\u0003;\u0002A\u0011KA0\u0003=)\u0007pY3qi&|gnQ1vO\"$H#B-\u0002b\u0005\r\u0004BB6\u0002\\\u0001\u0007A\u000e\u0003\u0005\u0002f\u0005m\u0003\u0019AA4\u0003\u0005!\b\u0003BA5\u0003grA!a\u001b\u0002p9\u0019q%!\u001c\n\u0003=K1!!\u001dO\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001e\u0002x\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003cr\u0005")
public class WebSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private final Function1<Function1<RpcResponseEnvelope, BoxedUnit>, Function1<RpcRequestEnvelope, BoxedUnit>> hookHandlers;
    private final Logger log;
    private final AttributeKey<Function1<String, BoxedUnit>> inHandlerKey;
    private final AttributeKey<Function1<RpcResponseEnvelope, BoxedUnit>> outHandlerKey;

    public Logger log() {
        return this.log;
    }

    public AttributeKey<Function1<String, BoxedUnit>> inHandlerKey() {
        return this.inHandlerKey;
    }

    public AttributeKey<Function1<RpcResponseEnvelope, BoxedUnit>> outHandlerKey() {
        return this.outHandlerKey;
    }

    private void setInHandler(ChannelHandlerContext ctx, Function1<String, BoxedUnit> inHandler) {
        ctx.channel().attr(this.inHandlerKey()).set(inHandler);
    }

    private Function1<String, BoxedUnit> getInHandler(ChannelHandlerContext ctx) {
        return (Function1)ctx.channel().attr(this.inHandlerKey()).get();
    }

    private void setOutHandler(ChannelHandlerContext ctx, Function1<RpcResponseEnvelope, BoxedUnit> outHandler) {
        ctx.channel().attr(this.outHandlerKey()).set(outHandler);
    }

    private Function1<RpcResponseEnvelope, BoxedUnit> getOutHandler(ChannelHandlerContext ctx) {
        return (Function1)ctx.channel().attr(this.outHandlerKey()).get();
    }

    private SubprotocolEncoder encoderFor(String subprotocol) {
        String string;
        block4: {
            SubprotocolEncoder subprotocolEncoder;
            block3: {
                block2: {
                    string = subprotocol;
                    if (!"jerky".equals(string)) break block2;
                    subprotocolEncoder = JerkySubprotocolEncoder$.MODULE$;
                    break block3;
                }
                if (!"swanky".equals(string)) break block4;
                subprotocolEncoder = SwankySubprotocolEncoder$.MODULE$;
            }
            return subprotocolEncoder;
        }
        throw new MatchError((Object)string);
    }

    private Function1<RpcResponseEnvelope, BoxedUnit> encodedOutHandler(Channel ch, SubprotocolEncoder encoder) {
        return new Serializable(this, ch, encoder){
            public static final long serialVersionUID = 0L;
            private final Channel ch$1;
            private final SubprotocolEncoder encoder$1;

            public final void apply(RpcResponseEnvelope rpcResp) {
                String response = this.encoder$1.writeFrame(rpcResp);
                this.ch$1.writeAndFlush((Object)new TextWebSocketFrame(response));
            }
            {
                this.ch$1 = ch$1;
                this.encoder$1 = encoder$1;
            }
        };
    }

    private Function1<String, BoxedUnit> encodedInHandler(Function1<RpcRequestEnvelope, BoxedUnit> inHandler, SubprotocolEncoder encoder) {
        return new Serializable(this, inHandler, encoder){
            public static final long serialVersionUID = 0L;
            private final Function1 inHandler$1;
            private final SubprotocolEncoder encoder$2;

            public final void apply(String frameText) {
                RpcRequestEnvelope rpcReq = this.encoder$2.readFrame(frameText);
                this.inHandler$1.apply((Object)rpcReq);
            }
            {
                this.inHandler$1 = inHandler$1;
                this.encoder$2 = encoder$2;
            }
        };
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            WebSocketServerProtocolHandler.HandshakeComplete serverHandshakeComplete = (WebSocketServerProtocolHandler.HandshakeComplete)evt;
            String subprotocol = serverHandshakeComplete.selectedSubprotocol();
            SubprotocolEncoder encoder = this.encoderFor(subprotocol);
            Function1<RpcResponseEnvelope, BoxedUnit> outHandler = this.encodedOutHandler(ctx.channel(), encoder);
            Function1<String, BoxedUnit> inHandler = this.encodedInHandler((Function1<RpcRequestEnvelope, BoxedUnit>)((Function1)this.hookHandlers.apply(outHandler)), encoder);
            this.setInHandler(ctx, inHandler);
            this.setOutHandler(ctx, outHandler);
            this.log().info("Handlers ready");
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)webSocketFrame;
            BoxedUnit boxedUnit = (BoxedUnit)this.getInHandler(ctx).apply((Object)textWebSocketFrame.text());
            return;
        }
        String message = new StringBuilder().append((Object)"Unsupported frame type: ").append((Object)frame.getClass().getName()).toString();
        throw new UnsupportedOperationException(message);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
        this.log().error("Error while processing WebSocket message", t);
        RpcResponseEnvelope error = new RpcResponseEnvelope((Option)None$.MODULE$, (EnsimeServerMessage)new EnsimeServerError(t.toString()));
        this.getOutHandler(ctx).apply((Object)error);
    }

    public WebSocketFrameHandler(Function1<Function1<RpcResponseEnvelope, BoxedUnit>, Function1<RpcRequestEnvelope, BoxedUnit>> hookHandlers) {
        this.hookHandlers = hookHandlers;
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.inHandlerKey = AttributeKey.valueOf(Function1.class, (String)"INHANDLER");
        this.outHandlerKey = AttributeKey.valueOf(Function1.class, (String)"OUTHANDLER");
    }
}

