/*
 * Decompiled with CFR 0.152.
 */
package org.ensime.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.activation.MimetypesFileTypeMap;
import org.ensime.core.DocJarReading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001%\u00111\u0002R8dg\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u00151\u0011AB3og&lWMC\u0001\b\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0002E\u0002\f%Qi\u0011\u0001\u0004\u0006\u0003\u001b9\tqa\u00195b]:,GN\u0003\u0002\u0010!\u0005)a.\u001a;us*\t\u0011#\u0001\u0002j_&\u00111\u0003\u0004\u0002\u001c'&l\u0007\u000f\\3DQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005UaR\"\u0001\f\u000b\u0005]A\u0012\u0001\u00025uiBT!!\u0007\u000e\u0002\u000b\r|G-Z2\u000b\u0005mq\u0011a\u00025b]\u0012dWM]\u0005\u0003;Y\u0011qBR;mY\"#H\u000f\u001d*fcV,7\u000f\u001e\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005!Am\\2t!\t\tC%D\u0001#\u0015\t\u0019C!\u0001\u0003d_J,\u0017BA\u0013#\u00055!un\u0019&beJ+\u0017\rZ5oO\")q\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\"\"!K\u0016\u0011\u0005)\u0002Q\"\u0001\u0002\t\u000b}1\u0003\u0019\u0001\u0011\t\u000f5\u0002!\u0019!C\u0001]\u00059Ai\\2MSN$X#A\u0018\u0011\u0005A:T\"A\u0019\u000b\u0005I\u001a\u0014\u0001C7bi\u000eD\u0017N\\4\u000b\u0005Q*\u0014\u0001B;uS2T\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qE\u0012QAU3hKbDaA\u000f\u0001!\u0002\u0013y\u0013\u0001\u0003#pG2K7\u000f\u001e\u0011\t\u000fq\u0002!\u0019!C\u0001]\u0005AAi\\2F]R\u0014\u0018\u0010\u0003\u0004?\u0001\u0001\u0006IaL\u0001\n\t>\u001cWI\u001c;ss\u0002Bq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011)\u0001\bd_:$XM\u001c;UsB,W*\u00199\u0016\u0003\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u0015\u0005\u001cG/\u001b<bi&|gNC\u0001H\u0003\u0015Q\u0017M^1y\u0013\tIEI\u0001\u000bNS6,G/\u001f9fg\u001aKG.\u001a+za\u0016l\u0015\r\u001d\u0005\u0007\u0017\u0002\u0001\u000b\u0011\u0002\"\u0002\u001f\r|g\u000e^3oiRK\b/Z'ba\u0002Bq!\u0014\u0001C\u0002\u0013\u0005a*A\u0002m_\u001e,\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u001a\tQa\u001d7gi)L!\u0001V)\u0003\r1{wmZ3s\u0011\u00191\u0006\u0001)A\u0005\u001f\u0006!An\\4!\u0011\u0015A\u0006\u0001\"\u0011Z\u00031\u0019\u0007.\u00198oK2\u0014V-\u001931)\rQfl\u0019\t\u00037rk\u0011!N\u0005\u0003;V\u0012A!\u00168ji\")ql\u0016a\u0001A\u0006\u00191\r\u001e=\u0011\u0005-\t\u0017B\u00012\r\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDQ\u0001Z,A\u0002Q\t1A]3r\u0011\u00151\u0007\u0001\"\u0003h\u0003A\u0001(o\u001c2f\u0007>tG/\u001a8u)f\u0004X\r\u0006\u0002imB\u00191,[6\n\u0005),$AB(qi&|g\u000e\u0005\u0002mg:\u0011Q.\u001d\t\u0003]Vj\u0011a\u001c\u0006\u0003a\"\ta\u0001\u0010:p_Rt\u0014B\u0001:6\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I,\u0004\"B<f\u0001\u0004Y\u0017\u0001\u00024jY\u0016DQ!\u001f\u0001\u0005\ni\f\u0001c]3oI\"#H\u000f\u001d*fgB|gn]3\u0015\ti[H0 \u0005\u0006?b\u0004\r\u0001\u0019\u0005\u0006Ib\u0004\r\u0001\u0006\u0005\u0006}b\u0004\ra`\u0001\u0010gR\fG/^:Pe\u000e{g\u000e^3oiBA\u0011\u0011AA\u0006\u0003#\t9B\u0004\u0003\u0002\u0004\u0005\u001dab\u00018\u0002\u0006%\ta'C\u0002\u0002\nU\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u000e\u0005=!AB#ji\",'OC\u0002\u0002\nU\u00022!FA\n\u0013\r\t)B\u0006\u0002\u0013\u0011R$\bOU3ta>t7/Z*uCR,8\u000f\u0005\u0004\\\u00033A\u0017QD\u0005\u0004\u00037)$A\u0002+va2,'\u0007\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019CD\u0001\u0007EV4g-\u001a:\n\t\u0005\u001d\u0012\u0011\u0005\u0002\b\u0005f$XMQ;g\u0011%\tY\u0003\u0001b\u0001\n\u0013\ti#A\u0006e_\u000eT\u0015M]:QC\u001e,WCAA\u000f\u0011!\t\t\u0004\u0001Q\u0001\n\u0005u\u0011\u0001\u00043pG*\u000b'o\u001d)bO\u0016\u0004\u0003")
public class DocsHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final DocJarReading docs;
    private final Regex DocList;
    private final Regex DocEntry;
    private final MimetypesFileTypeMap contentTypeMap;
    private final Logger log;
    private final ByteBuf docJarsPage;

    public Regex DocList() {
        return this.DocList;
    }

    public Regex DocEntry() {
        return this.DocEntry;
    }

    public MimetypesFileTypeMap contentTypeMap() {
        return this.contentTypeMap;
    }

    public Logger log() {
        return this.log;
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (!req.decoderResult().isSuccess()) {
            this.sendHttpResponse(ctx, req, (Either<HttpResponseStatus, Tuple2<Option<String>, ByteBuf>>)package$.MODULE$.Left().apply((Object)HttpResponseStatus.BAD_REQUEST));
        } else {
            HttpMethod httpMethod = req.method();
            HttpMethod httpMethod2 = HttpMethod.GET;
            if (httpMethod == null ? httpMethod2 != null : !httpMethod.equals(httpMethod2)) {
                this.sendHttpResponse(ctx, req, (Either<HttpResponseStatus, Tuple2<Option<String>, ByteBuf>>)package$.MODULE$.Left().apply((Object)HttpResponseStatus.FORBIDDEN));
            } else {
                String string = req.uri();
                Option option = this.DocList().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                    ByteBuf content = this.docJarsPage();
                    this.sendHttpResponse(ctx, req, (Either<HttpResponseStatus, Tuple2<Option<String>, ByteBuf>>)package$.MODULE$.Right().apply((Object)new Tuple2((Object)new Some((Object)"text/html"), (Object)content)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Option option2 = this.DocEntry().unapplySeq((CharSequence)string);
                    if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                        String filename = (String)((LinearSeqOptimized)option2.get()).apply(0);
                        String entry = (String)((LinearSeqOptimized)option2.get()).apply(1);
                        this.log().debug(new StringBuilder(22).append("Doc entry requested: ").append(filename).append("!").append(entry).toString());
                        BoxedUnit boxedUnit = (BoxedUnit)this.docs.docJarContent(filename, entry).fold((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sendHttpResponse(ctx, req, (Either<HttpResponseStatus, Tuple2<Option<String>, ByteBuf>>)package$.MODULE$.Left().apply((Object)HttpResponseStatus.NOT_FOUND)), (Function1 & Serializable & scala.Serializable)jarContent -> {
                            DocsHandler.$anonfun$channelRead0$2(this, ctx, req, entry, jarContent);
                            return BoxedUnit.UNIT;
                        });
                    } else {
                        this.sendHttpResponse(ctx, req, (Either<HttpResponseStatus, Tuple2<Option<String>, ByteBuf>>)package$.MODULE$.Left().apply((Object)HttpResponseStatus.NOT_FOUND));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        }
    }

    private Option<String> probeContentType(String file) {
        None$ none$;
        block4: {
            try {
                String ct;
                String string = ct = this.contentTypeMap().getContentType(file);
                String string2 = "application/octet-stream";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.log().warn(new StringBuilder(32).append("ContentType not found for file: ").append(file).toString());
                    none$ = None$.MODULE$;
                    break block4;
                }
                this.log().debug(new StringBuilder(18).append("ContentType for ").append(file).append(": ").append(ct).toString());
                none$ = new Some((Object)ct);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.log().error(new StringBuilder(42).append("Error while probing ContentType for file: ").append(file).toString(), e);
                None$ none$2 = None$.MODULE$;
                none$ = none$2;
            }
        }
        return none$;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, Either<HttpResponseStatus, Tuple2<Option<String>, ByteBuf>> statusOrContent) {
        block4: {
            Right right;
            Tuple2 tuple2;
            DefaultFullHttpResponse defaultFullHttpResponse;
            this.log().debug(new StringBuilder(33).append("Sending response: ").append(statusOrContent).append(", for request: ").append(req).toString());
            Either<HttpResponseStatus, Tuple2<Option<String>, ByteBuf>> either = statusOrContent;
            if (either instanceof Left) {
                Left left = (Left)either;
                HttpResponseStatus status = (HttpResponseStatus)left.value();
                DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
                ByteBuf buf = Unpooled.copiedBuffer((CharSequence)status.toString(), (Charset)CharsetUtil.UTF_8);
                res.content().writeBytes(buf);
                buf.release();
                defaultFullHttpResponse = res;
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                Option mimeTypeOpt = (Option)tuple2._1();
                ByteBuf content = (ByteBuf)tuple2._2();
                DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                mimeTypeOpt.foreach((Function1 & Serializable & scala.Serializable)mimeType -> res.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)new StringBuilder(15).append((String)mimeType).append("; charset=UTF-8").toString()));
                defaultFullHttpResponse = res;
            } else {
                throw new MatchError(either);
            }
            DefaultFullHttpResponse res = defaultFullHttpResponse;
            HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
            ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
            if (HttpUtil.isKeepAlive((HttpMessage)req) && res.status().code() == HttpResponseStatus.OK.code()) break block4;
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private ByteBuf docJarsPage() {
        return this.docJarsPage;
    }

    public static final /* synthetic */ void $anonfun$channelRead0$2(DocsHandler $this, ChannelHandlerContext ctx$1, FullHttpRequest req$1, String entry$1, byte[] jarContent) {
        Option<String> mediaOpt = $this.probeContentType(entry$1);
        ByteBuf content = Unpooled.copiedBuffer((byte[])jarContent);
        $this.sendHttpResponse(ctx$1, req$1, (Either<HttpResponseStatus, Tuple2<Option<String>, ByteBuf>>)package$.MODULE$.Right().apply((Object)new Tuple2(mediaOpt, (Object)content)));
    }

    private final List jars$1() {
        return (List)((SeqLike)this.docs.docJars().toList().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
    }

    public DocsHandler(DocJarReading docs) {
        this.docs = docs;
        this.DocList = new StringOps(Predef$.MODULE$.augmentString("/docs/?")).r();
        this.DocEntry = new StringOps(Predef$.MODULE$.augmentString("/docs/([^/]+\\.jar)/(.+?)(?:#.*)?")).r();
        this.contentTypeMap = new MimetypesFileTypeMap();
        this.log = LoggerFactory.getLogger((Class)this.getClass());
        String jarRefs = ((TraversableOnce)this.jars$1().map((Function1 & Serializable & scala.Serializable)jar -> new StringBuilder(40).append("<li><a href=\"docs/").append((String)jar).append("/index.html\">").append((String)jar).append("</a></li>").toString(), List$.MODULE$.canBuildFrom())).mkString(String.format("%-12s", "\n"));
        String content = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("|<html>\n          |    <body>\n          |        <h1>ENSIME: Your Project's Documentation</h1>\n          |        <ul>\n          |           ").append(jarRefs).append("\n          |        </ul>\n          |    </body>\n          |</html>\n          |").toString())).stripMargin();
        this.docJarsPage = Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8);
    }
}

