/*
 * Decompiled with CFR 0.152.
 */
package org.ensime.server;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Terminated;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import io.netty.channel.Channel;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ensime.AkkaBackCompat;
import org.ensime.api.EnsimeConfig;
import org.ensime.api.EnsimeServerConfig;
import org.ensime.config.EnsimeConfigProtocol$;
import org.ensime.config.richconfig.package$;
import org.ensime.core.Canon$;
import org.ensime.core.ShutdownRequest;
import org.ensime.server.FramedStringProtocol;
import org.ensime.server.ServerActor$;
import org.ensime.server.SwankProtocol;
import org.ensime.server.SwankiProtocol;
import org.ensime.util.Slf4jSetup$;
import org.ensime.util.ensimefile.package;
import org.ensime.util.path.package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Try$;

public final class Server$
implements AkkaBackCompat {
    public static Server$ MODULE$;
    private final Logger log;

    static {
        new Server$();
    }

    public Logger log() {
        return this.log;
    }

    public Config loadConfig() {
        Config fallback = ConfigFactory.load();
        List user = (List)((List)((TraversableLike)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{package$.MODULE$.parseServerConfig(fallback).config().file().getParent(), Paths.get((String)scala.sys.package$.MODULE$.env().get((Object)"XDG_CONFIG_HOME").getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)scala.sys.package$.MODULE$.props().apply((Object)"user.home")), new String[0])})).map((Function1 & Serializable & scala.Serializable)x$1 -> package.RichPath$.MODULE$.$div$extension(org.ensime.util.path.package$.MODULE$.RichPath(x$1), ".ensime-server.conf"), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)package.RichPath$.MODULE$.exists$extension(org.ensime.util.path.package$.MODULE$.RichPath(x$2))))).map((Function1 & Serializable & scala.Serializable)p -> ConfigFactory.parseFile((File)p.toFile()), List$.MODULE$.canBuildFrom());
        Config config = ConfigFactory.systemProperties();
        List list = user;
        Config config2 = fallback;
        return (Config)Nil$.MODULE$.$colon$colon((Object)config2).$colon$colon$colon(list).$colon$colon((Object)config).reduce((Function2 & Serializable & scala.Serializable)(higher, lower) -> higher.withFallback((ConfigMergeable)lower));
    }

    public void main(String[] args) {
        FramedStringProtocol framedStringProtocol;
        Config config = this.loadConfig();
        EnsimeServerConfig serverConfig = package$.MODULE$.parseServerConfig(config);
        EnsimeConfig ensimeConfig = EnsimeConfigProtocol$.MODULE$.parse(package.RichPath$.MODULE$.readString$extension(org.ensime.util.path.package$.MODULE$.RichPath(serverConfig.config().file()), package.Implicits$.MODULE$.DefaultCharset()));
        Canon$.MODULE$.config_$eq(ensimeConfig);
        Canon$.MODULE$.serverConfig_$eq(serverConfig);
        String string = serverConfig.protocol();
        if ("swanki".equals(string)) {
            framedStringProtocol = new SwankiProtocol();
        } else if ("swank".equals(string)) {
            framedStringProtocol = new SwankProtocol();
        } else {
            throw new IllegalArgumentException(new StringBuilder(31).append(string).append(" is not a valid ENSIME protocol").toString());
        }
        SwankiProtocol protocol = framedStringProtocol;
        ActorSystem$.MODULE$.create("ENSIME", config).actorOf(ServerActor$.MODULE$.props(protocol, ensimeConfig, serverConfig), "ensime-main");
    }

    public void shutdown(ActorSystem system, Channel channel, ShutdownRequest request, boolean exit) {
        Thread t = new Thread(new Runnable(system, channel, request, exit){
            private final ActorSystem system$1;
            private final Channel channel$1;
            private final ShutdownRequest request$1;
            private final boolean exit$1;

            public void run() {
                block4: {
                    if (this.request$1.isError()) {
                        Server$.MODULE$.log().error(new StringBuilder(42).append("Shutdown requested due to internal error: ").append(this.request$1.reason()).toString());
                    } else {
                        Server$.MODULE$.log().info(new StringBuilder(20).append("Shutdown requested: ").append(this.request$1.reason()).toString());
                    }
                    Server$.MODULE$.log().info("Shutting down the ActorSystem");
                    Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.system$1.terminate());
                    Server$.MODULE$.log().info("Awaiting actor system termination");
                    Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Terminated)Await$.MODULE$.result((Awaitable)$this.system$1.whenTerminated(), (Duration)Duration$.MODULE$.Inf()));
                    Server$.MODULE$.log().info("Shutting down the Netty channel");
                    Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.channel$1.close().sync());
                    Server$.MODULE$.log().info("Shutdown complete");
                    if (!this.exit$1) break block4;
                    if (this.request$1.isError()) {
                        System.exit(1);
                    } else {
                        System.exit(0);
                    }
                }
            }
            {
                this.system$1 = system$1;
                this.channel$1 = channel$1;
                this.request$1 = request$1;
                this.exit$1 = exit$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.ensime.server.Server$$anon$2 ), $anonfun$run$2(org.ensime.server.Server$$anon$2 ), $anonfun$run$3(org.ensime.server.Server$$anon$2 )}, serializedLambda);
            }
        });
        t.setName("Server Shutdown");
        t.setDaemon(true);
        t.start();
    }

    private Server$() {
        MODULE$ = this;
        Slf4jSetup$.MODULE$.init();
        this.log = LoggerFactory.getLogger((String)"Server");
    }
}

